<?php 
$settings[] = array(
                'id' => 'portfolio',
                'title' => esc_html__('PORTFOLIO', 'themo'),
                'sections' => array(
                    array(
                        'id' => 'portfolio_settings',
                        'title' => esc_html__('SETTINGS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_settings][info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('Notice, that all options below will not be visible on the preview right after you change them. To see those changes you have to Save changes and refresh Customizer.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_settings][main_page]',
                                'type' => 'text',
                                'label' => esc_html__('MAIN PORTFOLIO PAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_settings.main_page'),
                                'description' => __('Enter full link to the page which you want to bacome the main portfolio page. This link will be used for portfolio breadcrumbs and for portfolio list icon in portfolio navigation bar. User will be able to navigate form single portfolio post to main portfolio page using breadcrumbs or portfolio list icon. If you leave this field empty then portfolio list icon will not be displayed in navigation bar and portfolio link will not be displayed in breadcrumbs.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_settings][slug]',
                                'type' => 'text',
                                'label' => esc_html__('PORTFOLIO SLUG', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_settings.slug'),
                                'description' => __('Portfolio slug is a substitute text for main portfolio page which is displayed in portfolio links. By default portfolio links structure looks like: home / portfolio / single portfolio item name. If you enter word <i>projects</i> as Portfolio slug then your link will be look like: home / projects / single portfolio item name. If you leave Portfolio slug field empty then in your link <i>portfolio</i> slug will be displayed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'portfolio_settings',
                        'title' => esc_html__('NAVIGATION', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_navigation][info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('In this section you can enable and customize colors for standard portfolio posts navigation. Notice, that below option do not affect Ajax Card.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_navigation][enabled]',
                                'type' => 'switcher',
                                'label' => esc_html__('NAVIGATION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_navigation.enabled'),
                                'description' => '',
                                'depending' => array(
                                    'true' => array('ideo_theme_options[portfolio][portfolio_navigation][background_color]', 'ideo_theme_options[portfolio][portfolio_navigation][border_top_color]', 'ideo_theme_options[portfolio][portfolio_navigation][border_bottom_color]', 'ideo_theme_options[portfolio][portfolio_navigation][text_color]', 'ideo_theme_options[portfolio][portfolio_navigation][accent_color]'),
                                    'false' => array(''),
                                ),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_navigation][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_navigation.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_navigation][border_top_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER TOP COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_navigation.border_top_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_navigation][border_bottom_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_navigation.border_bottom_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_navigation][text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_navigation.text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_navigation][accent_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('ACCENT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_navigation.accent_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'portfolio_standard_card',
                        'title' => esc_html__('AJAX CARD SOCIAL SHARE', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('Notice, that all options below will not be visible on the preview right after you change them. To see those changes you have to Save changes and refresh Customizer.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][social_media_share]',
                                'type' => 'switcher',
                                'label' => esc_html__('SOCIAL MEDIA SHARE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.social_media_share'),
                                'depending' => array(
                                    'true' => array('ideo_theme_options[portfolio][portfolio_standard_card][facebook]', 'ideo_theme_options[portfolio][portfolio_standard_card][twitter]', 'ideo_theme_options[portfolio][portfolio_standard_card][google]', 'ideo_theme_options[portfolio][portfolio_standard_card][pinterest]', 'ideo_theme_options[portfolio][portfolio_standard_card][reddit]', 'ideo_theme_options[portfolio][portfolio_standard_card][linkedin]', 'ideo_theme_options[portfolio][portfolio_standard_card][tumblr]', 'ideo_theme_options[portfolio][portfolio_standard_card][vk]', 'ideo_theme_options[portfolio][portfolio_standard_card][email]'),
                                    'false' => array(''),
                                ),
                                'description' => __('Turn On or Off social media share icons. If it is On social media checkboxes will be available below, check those which you want to display on portfolio single posts', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][facebook]',
                                'type' => 'switcher',
                                'label' => esc_html__('Facebook', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.facebook'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][twitter]',
                                'type' => 'switcher',
                                'label' => esc_html__('Twitter', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.twitter'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][google]',
                                'type' => 'switcher',
                                'label' => esc_html__('Google+', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.google'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][reddit]',
                                'type' => 'switcher',
                                'label' => esc_html__('Reddit', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.reddit'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][linkedin]',
                                'type' => 'switcher',
                                'label' => esc_html__('Linked In', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.linkedin'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][tumblr]',
                                'type' => 'switcher',
                                'label' => esc_html__('Tumblr', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.tumblr'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][pinterest]',
                                'type' => 'switcher',
                                'label' => esc_html__('Pinterest', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.pinterest'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][vk]',
                                'type' => 'switcher',
                                'label' => esc_html__('Vk', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.vk'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[portfolio][portfolio_standard_card][email]',
                                'type' => 'switcher',
                                'label' => esc_html__('Email', 'themo'),
                                'default' => ideothemo_get_themo_default_value('portfolio.portfolio_standard_card.email'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                ),
            );