<?php
$settings[] = array(
                'id' => 'pagetitle',
                'title' => esc_html__('PAGE TITLE', 'themo'),
                'sections' => array(
                    array(
                        'id' => 'page_title_settings',
                        'title' => esc_html__('SETTINGS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][pagetitle-separator]',
                                'type' => 'separator',
                                'label' => esc_html__('PAGE TITLE', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][page_title_area]',
                                'type' => 'switcher',
                                'label' => esc_html__('PAGE TITLE AREA', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_settings.page_title_area'),
                                'description' => __('Turn On or Off Page title area globally, over your whole site. Remember, that you can override this setting on every particular page or post using Page options.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][page_title_area_skin]',
                                'type' => 'select',
                                'label' => esc_html__('SKIN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_settings.page_title_area_skin'),
                                'choices' => array(
                                    '' => 'default',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose global skin for Page title area. You can choose between Light (light fonts) and Dark (dark fonts) skin and customize colors for chosen skin in Coloring section below. With THEMO you can use different page title skins on different pages so beside global skin you can customize colors for second skin and apply for this skin in Page options.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][page_title_area_height]',
                                'type' => 'slider',
                                'label' => esc_html__('HEIGHT ', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_settings.page_title_area_height'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '1200',
                                    'step' => '1',
                                ),
                                'description' => __('Set height of page title area in pixels. !!! Notice that Page title area height is calculated from the top of the page, so it contains header, topbar and header top distance.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][page_title_area_content_align]',
                                'type' => 'select',
                                'label' => esc_html__('CONTENT ALIGN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_settings.page_title_area_content_align'),
                                'choices' => array(
                                    'left' => 'Left',
                                    'center' => 'Center',
                                    'right' => 'Right',
                                ),
                                'description' => __('Justify content elements (title and subtitle) to the Left, Center or Right side of page title area.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_parallax]',
                                'type' => 'switcher',
                                'label' => esc_html__('PARALLAX EFFECT ', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_parallax'),
                                'description' => __('Page title parallax effect is a additional effect which makes that the content (page title and subtitle) moves irrespectively of the background and gets additional fade-out animation.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][breadcrumbs-separator]',
                                'type' => 'separator',
                                'label' => esc_html__('BREADCRUMBS', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][breadcrumbs_area]',
                                'type' => 'switcher',
                                'label' => esc_html__('BREADCRUMBS AREA', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_settings.breadcrumbs_area'),
                                'description' => __('Turn On or Off Breadcrums area globally, over your whole site. Remember, that you can override this setting on every particular page using Page options.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][breadcrumbs_position]',
                                'type' => 'select',
                                'label' => esc_html__('BREADCRUMBS POSITION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_settings.breadcrumbs_position'),
                                'choices' => array(
                                    'bottom' => 'Bottom',
                                    'inside' => 'Inside',
                                ),
                                'description' => __('Choose breadcrumbs position. When you choose BOTTOM then Breadcrumbs will be placed at the very bottom of Page title container, independently of the content (title and subtitle). When you choose INSIDE then breadcrumbs will be placed inside the content container and positioning in relation to the title and subtitle (depending on content alignment).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_settings][breadcrumbs_mobile]',
                                'type' => 'switcher',
                                'label' => esc_html__('SHOW ON MOBILE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_settings.breadcrumbs_mobile'),
                                'description' => __('Turn on this option if you want to display breadcrumbs on mobile devices.', 'themo'),
                                'transport' => 'postMessage',
                            )
                        ),
                    ),
                    array(
                        'id' => 'page_title_background',
                        'title' => esc_html__('BACKGROUND', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][page_title_area_background]',
                                'type' => 'select',
                                'label' => esc_html__('PAGE TITLE AREA BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.page_title_area_background'),
                                'choices' => array(
                                    '' => 'Default',
                                    'color' => 'Color',
                                    'image' => 'Image',
                                    'video' => 'Video',
                                ),
                                'depending' => array(
                                    'color' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_color]'),
                                    'image' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_upload_image]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_cover]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_position]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_repeat]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_motion]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_overlay]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_moving_speed]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_color_overlay]'),
                                    'video' => array(
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_video_platform]',
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_youtube]',
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_mp4]',
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_webm]',
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_fallback_image]',
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay]',
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_color]',
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_pattern]',
                                        'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_pattern_color]'),
                                ),
                                'description' => __('Choose Color, Image or Video background type for content area. Depending on which option you choose appropriate options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_color_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_color_overlay'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_color_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_color_pattern]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_color_pattern_color]'),
                                ),
                                'description' => __('Choose between Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose the additional options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_color_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_color_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_color_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_color_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_color_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_color_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_upload_image]',
                                'type' => 'upload',
                                'label' => esc_html__('UPLOAD IMAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_upload_image'),
                                'description' => __('Upload image which will be set as a background. Only .jpg .png .bmp formats are allowed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_cover]',
                                'type' => 'switcher',
                                'label' => esc_html__('100% BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_cover'),
                                'description' => __('Turn On this option to set COVER property for background image size (it will be scale to be as large as possible so that the background area is completely covered by the background image). By default this option is turned Off, so background image size has set <i>auto</i> property (original width and height).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_position]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE POSITION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_image_position'),
                                'choices' => array(
                                    'left_top' => 'Left top',
                                    'center_top' => 'Center top',
                                    'right_top' => 'Right top',
                                    'left_center' => 'Left center',
                                    'center_center' => 'Center center',
                                    'right_center' => 'Right center',
                                    'left_bottom' => 'Left bottom',
                                    'center_bottom' => 'Center bottom',
                                    'right_bottom' => 'Right bottom',
                                ),
                                'description' => __('Choose image position property to set the starting position of background image.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_repeat]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE REPEAT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_image_repeat'),
                                'choices' => array(
                                    'no_repeat' => 'No repeat',
                                    'repeat_x' => 'Repeat X',
                                    'repeat_y' => 'Repeat Y',
                                    'repeat' => 'Repeat XY',
                                ),
                                'description' => __('Choose image repeat property to set if/how the background image will be repeated.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_motion]',
                                'type' => 'select',
                                'label' => esc_html__('BACKGROUND MOTION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_motion'),
                                'choices' => array(
                                    'scroll' => 'Scroll',
                                    'fixed' => 'Fixed',
                                    'parallax' => 'Parallax',
                                ),
                                'depending' => array(
                                    'scroll' => array(''),
                                    'fixed' => array(''),
                                    'parallax' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_moving_speed]'),
                                ),
                                'description' => __('Choose between 3 types of background image motion:</br><b>Scroll</b> (the background image scrolls along with elements), </br><b>Fixed</b> (the background image is fixed with regard to the viewport), </br><b>Parallax</b> (background image moves irrespectively of elements). </br>Notice that Parallax motion override background-position, so background position which is set above will not work if you are going to use Parallax background.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_moving_speed]',
                                'type' => 'text',
                                'label' => esc_html__('MOVING SPEED ', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_moving_speed'),
                                'description' => __('Define background image vertical motion speed in relation to scrolling speed. You can set values between -2 to 2. 0 value means that your background image will be moving the same speed as scroll. </br>!!! If you are going to use negative values your background image should be repeated.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_image_overlay'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_image_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_image_overlay_pattern]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_overlay_pattern_color]'),
                                ),
                                'description' => __('Choose Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose several styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_image_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_overlay_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_image_overlay_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_image_overlay_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_image_overlay_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_video_platform]',
                                'type' => 'select',
                                'label' => esc_html__('VIDEO PLATFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_video_platform'),
                                'choices' => array(
                                    'youtube' => 'Youtube',
                                    'self_hosted' => 'Self hosted',
                                ),
                                'depending' => array(
                                    'youtube' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_youtube]'),
                                    'self_hosted' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_mp4]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_webm]'),
                                ),
                                'description' => __('Choose the hosting platform from which you want to upload background video. Depending on which option you choose appropriate options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_youtube]',
                                'type' => 'text',
                                'label' => esc_html__('YOUTUBE VIDEO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_youtube'),
                                'description' => __('Enter link to Youtube video.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_mp4]',
                                'type' => 'text',
                                'label' => esc_html__('MP4 FORMAT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_mp4'),
                                'description' => __('Enter link to MP4 video. It has to be direct link to the file - it should have .mp4 extension at the end of the link. Notice, that if you are using selfhosted video you should also add WebM video to have guarantee that your video will be displayed on every browser.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_webm]',
                                'type' => 'text',
                                'label' => esc_html__('WEBM FORMAT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_webm'),
                                'description' => __('Enter link to WebM video. It has to be direct link to the file - it should have .webm extension at the end of the link. Notice, that if you are using selfhosted video you should also add MP4 video to have guarantee that your video will be displayed on every browser.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_fallback_image]',
                                'type' => 'upload',
                                'label' => esc_html__('FALLBACK & MOBILE IMAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_fallback_image'),
                                'description' => __('Upload fallback image which will be display on mobile devices instead of video. Fallback image will be also displayed on desktop devices until your video will load. Only .jpg .png .bmp image formats are allowed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('VIDEO OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_video_overlay'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_pattern]', 'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_pattern_color]'),
                                ),
                                'description' => __('Choose between Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose the additional options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_video_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_video_overlay_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_background][pt_background_video_overlay_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_background.pt_background_video_overlay_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'page_title_fonts',
                        'title' => esc_html__('FONTS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'separator_pt_title',
                                'type' => 'separator',
                                'label' => esc_html__('TITLE FONT', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_title_font_size]',
                                'type' => 'text',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_title_font_size'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_title_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_title_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_title_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_title_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_title_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_title_font_weight'),
                                'depends' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_title_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_title_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_title_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_title_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_title_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'separator_pt_subtitle',
                                'type' => 'separator',
                                'label' => esc_html__('SUBTITLE FONT', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_subtitle_font_size]',
                                'type' => 'text',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_subtitle_font_size'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_subtitle_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_subtitle_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_subtitle_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_subtitle_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_subtitle_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_subtitle_font_weight'),
                                'depends' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_subtitle_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_subtitle_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_subtitle_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_subtitle_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_subtitle_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'separator_pt_breadcrumbs',
                                'type' => 'separator',
                                'label' => esc_html__('BREADCRUMBS FONT', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_breadcrumbs_font_size]',
                                'type' => 'text',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_breadcrumbs_font_size'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_breadcrumbs_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_breadcrumbs_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_breadcrumbs_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_breadcrumbs_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_breadcrumbs_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_breadcrumbs_font_weight'),
                                'depends' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_breadcrumbs_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_breadcrumbs_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_breadcrumbs_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_fonts][pt_breadcrumbs_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_fonts.pt_breadcrumbs_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'page_title_coloring',
                        'title' => esc_html__('COLORING', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'separator_pt_light_skin',
                                'type' => 'separator',
                                'label' => esc_html__('LIGHT SKIN', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_light_title_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TITLE COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_light_title_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_light_subtitle_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SUBTITLE COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_light_subtitle_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_light_b_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BREADCRUMBS TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_light_b_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_light_b_text_accent_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BREADCRUMBS TEXT ACCENT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_light_b_text_accent_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_light_b_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BREADCRUMBS BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_light_b_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_light_b_border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BREADCRUMBS BORDER TOP COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_light_b_border_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'separator_pt_dark_skin',
                                'type' => 'separator',
                                'label' => esc_html__('DARK SKIN', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_dark_title_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TITLE COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_dark_title_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_dark_subtitle_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SUBTITLE COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_dark_subtitle_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_dark_b_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BREADCRUMBS TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_dark_b_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_dark_b_text_accent_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BREADCRUMBS TEXT ACCENT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_dark_b_text_accent_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_dark_b_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BREADCRUMBS BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_dark_b_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[pagetitle][page_title_coloring][pt_dark_b_border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BREADCRUMBS BORDER TOP COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('pagetitle.page_title_coloring.pt_dark_b_border_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                ),
            );