<?php 
$settings[] = array(
                'id' => 'HEADER',
                'title' => esc_html__('HEADER', 'themo'),
                'sections' => array(
                    array(
                        'id' => 'header_section_type',
                        'title' => esc_html__('HEADER TYPE', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][header_section_type][header_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('Choose global header type. General header type you choose in Customizer became default header (it will be displayed by default on every page) but you can choose different header type for individual page in Page options.</br></br>
					THEMO gives 4 different header types:<ul style="margin-top:7px;>
      <li style="margin-top:7px;"><b>TOP HEADER:</b> Top header stays at the top of the page after scroll.</li>
      <li style="margin-top:7px;"><b>STICKY HEADER:</b> Sticky header gets fixed position in relation to the browser window, so it stays visible on the screen after scroll. Initial header (Top header) stays at the top of the page (disappear after scroll) but final header (Sticky header) fade in and stays sticked to the top of the browser (so it stays visible on the screen).</li>
      <li style="margin-top:7px;"><b>STICKY HEADER SLIDE:</b> Sticky header slide works like Sticky header described above but it has different effect of entry, it slides down after scroll and you are able to define after how many pixels it slides down.</li>
      <li style="margin-top:7px;"><b>SIDE HEADER:</b> Side header is displayed on left or right side of the browser window.</li>
      <li style="margin-top:7px;"><b>SIDE OFF-CANVAS:</b> Side off-canvas header displays only the bar with menu icon and when you click or hover on the menu icon then Side header will slide in.</li>
</ul></br>', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][type]',
                                'type' => 'visual-select',
                                'label' => esc_html__('HEADER TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.type'),
                                'choices' => array(
                                    'standard_header' => array(
                                        'title' => 'Top header',
                                        'image' => 'header_type_top.png'
                                    ),
                                    'sticky_header' => array(
                                        'title' => 'Top/Sticky fade',
                                        'image' => 'header_type_sticky_fade.png'
                                    ),
                                    'sticky_slide_header' => array(
                                        'title' => 'Top/Sticky slide',
                                        'image' => 'header_type_sticky_slide.png'
                                    ),
                                    'sticky_slide_hide_header' => array(
                                        'title' => 'Top/Sticky slide & hide',
                                        'image' => 'header_type_sticky_slide_hide.png'
                                    ),
                                    'side_left_header' => array(
                                        'title' => 'Side header - left',
                                        'image' => 'header_type_side_left.png'
                                    ),
                                    'side_right_header' => array(
                                        'title' => 'Side header - right',
                                        'image' => 'header_type_side_right.png'
                                    ),
                                    'side_offcanvas_left_header' => array(
                                        'title' => 'Side header offcanvas - left',
                                        'image' => 'header_type_side_offcanvas_left.png'
                                    ),
                                    'side_offcanvas_right_header' => array(
                                        'title' => 'Side header offcanvas - right',
                                        'image' => 'header_type_side_offcanvas_right.png'
                                    ),
                                ),
                                'description' => '',
                                'transport' => 'refresh',
                                'depending' => array(
                                    'standard_header' => array('ideo_theme_options[header][top]', 'ideo_theme_options[header][sticky]', 'ideo_theme_options[header][mobile]', 'ideo_theme_options[header][top_sticky][colored][light]', 'ideo_theme_options[header][top_sticky][colored][dark]', 'ideo_theme_options[header][top_sticky][transparent][light]', 'ideo_theme_options[header][top_sticky][transparent][dark]'),
                                    'sticky_header' => array('ideo_theme_options[header][top]', 'ideo_theme_options[header][sticky]', 'ideo_theme_options[header][mobile]', 'ideo_theme_options[header][top_sticky][colored][light]', 'ideo_theme_options[header][top_sticky][colored][dark]', 'ideo_theme_options[header][top_sticky][transparent][light]', 'ideo_theme_options[header][top_sticky][transparent][dark]'),
                                    'sticky_slide_header' => array('ideo_theme_options[header][top]', 'ideo_theme_options[header][sticky]', 'ideo_theme_options[header][mobile]', 'ideo_theme_options[header][top_sticky][colored][light]', 'ideo_theme_options[header][top_sticky][colored][dark]', 'ideo_theme_options[header][top_sticky][transparent][light]', 'ideo_theme_options[header][top_sticky][transparent][dark]'),
                                    'sticky_slide_hide_header' => array('ideo_theme_options[header][top]', 'ideo_theme_options[header][sticky]', 'ideo_theme_options[header][mobile]', 'ideo_theme_options[header][top_sticky][colored][light]', 'ideo_theme_options[header][top_sticky][colored][dark]', 'ideo_theme_options[header][top_sticky][transparent][light]', 'ideo_theme_options[header][top_sticky][transparent][dark]'),
                                    'side_left_header' => array('ideo_theme_options[header][side]', 'ideo_theme_options[header][mobile]', 'ideo_theme_options[header][side][light][styling]', 'ideo_theme_options[header][side][dark][styling]'),
                                    'side_right_header' => array('ideo_theme_options[header][side]', 'ideo_theme_options[header][mobile]', 'ideo_theme_options[header][side][light][styling]', 'ideo_theme_options[header][side][dark][styling]'),
                                    'side_offcanvas_left_header' => array('ideo_theme_options[header][side]', 'ideo_theme_options[header][mobile]', 'ideo_theme_options[header][side][light][styling]', 'ideo_theme_options[header][side][dark][styling]'),
                                    'side_offcanvas_right_header' => array('ideo_theme_options[header][side]', 'ideo_theme_options[header][mobile]', 'ideo_theme_options[header][side][light][styling]', 'ideo_theme_options[header][side][dark][styling]'),
                                ),
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][logo]',
                        'title' => esc_html__('LOGOS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][logo][logo_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('In this section you can add logos, and next you have to choose one of these logos  (in appropriate headers sections) for header which you are going to use. If you are going to use one header type over your whole website simply upload Normal logo and choose it for your header. Remember however, that with THEMO you can use different headers on different pages so you can add as many logos as you need for your headers.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][normal]',
                                'type' => 'upload',
                                'label' => esc_html__('NORMAL LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.normal'),
                                'description' => __('Upload main logo version which will be used as default logo for all header types and styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][light]',
                                'type' => 'upload',
                                'label' => esc_html__('LIGHT LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.light'),
                                'description' => __('Upload Light logo version for Top and Side headers to use it instead of Normal logo for appropriate Top and Side headers styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][dark]',
                                'type' => 'upload',
                                'label' => esc_html__('DARK LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.dark'),
                                'description' => __('Upload Dark logo version for Top and Side headers to use it instead of Normal logo for appropriate Top and Side headers styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][sticky][dark]',
                                'type' => 'upload',
                                'label' => esc_html__('STICKY DARK LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.sticky.dark'),
                                'description' => __('Upload Sticky dark logo version to use it instead of Normal logo for appropriate Sticky header styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][sticky][light]',
                                'type' => 'upload',
                                'label' => esc_html__('STICKY LIGHT LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.sticky.light'),
                                'description' => __('Upload Sticky light logo version to use it instead of Normal logo for appropriate Sticky header styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][retina][enable]',
                                'type' => 'switcher',
                                'label' => esc_html__('ENABLE RETINA LOGOS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.retina.enable'),
                                'depending' => array(
                                    'false' => array(),
                                    'true' => array(
                                        'ideo_theme_options[header][logo][retina][normal]',
                                        'ideo_theme_options[header][logo][retina][light]',
                                        'ideo_theme_options[header][logo][retina][dark]',
                                        'ideo_theme_options[header][logo][retina][sticky][dark]',
                                        'ideo_theme_options[header][logo][retina][sticky][light]'
                                    )
                                ),
                                'description' => __('Turn On or Off retina logo support. If you turn it on appropriate upload fields will be available below. Retina logo version is sharper on hi-res screens, its size should be twice bigger than standard version.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][retina][normal]',
                                'type' => 'upload',
                                'label' => esc_html__('RETINA NORMAL LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.retina.normal'),
                                'description' => __('Upload Retina Normal logo which will be used as default logo for all header types and styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][retina][light]',
                                'type' => 'upload',
                                'label' => esc_html__('RETINA LIGHT LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.retina.light'),
                                'description' => __('Upload Retina light logo version for Top and Side headers.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][retina][dark]',
                                'type' => 'upload',
                                'label' => esc_html__('RETINA DARK LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.retina.dark'),
                                'description' => __('Upload Retina dark logo version for Top and Side.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][retina][sticky][dark]',
                                'type' => 'upload',
                                'label' => esc_html__('RETINA STICKY DARK LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.retina.sticky.dark'),
                                'description' => __('Upload Retina dark logo version for Sticky header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][logo][retina][sticky][light]',
                                'type' => 'upload',
                                'label' => esc_html__('RETINA STICKY LIGHT LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.retina.sticky.light'),
                                'description' => __('Upload Retina light logo version for Sticky header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][top]',
                        'title' => esc_html__('SETTINGS: Top/sticky & topbar', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][top][align][menu]',
                                'type' => 'select',
                                'label' => esc_html__('MENU ALIGN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.align.menu'),
                                'choices' => array(
                                    'left' => 'Left',
                                    'center' => 'Center',
                                    'right' => 'Right',
                                ),
                                'description' => __('Justify menu content to the Left, Center or Right side of the Top/Sticky header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][first_level_menu_hover_style]',
                                'type' => 'select',
                                'label' => esc_html__('FIRST LEVEL MENU HOVER STYLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.first_level_menu_hover_style'),
                                'choices' => array(
                                    'hover-style1' => 'Style 1',
                                    'hover-style2' => 'Style 2',
                                    'hover-style3' => 'Style 3',
                                    'hover-style4' => 'Style 4',
                                    'hover-style5' => 'Style 5',
                                ),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][dropdown_animation]',
                                'type' => 'select',
                                'label' => esc_html__('DROPDOWN & MEGA MENU ANIMATION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.dropdown_animation'),
                                'choices' => array(
                                    'dropdown-slide' => 'Slide',
                                    'dropdown-fade' => 'Fade',
                                    'dropdown-slide-up' => 'SlideUp',
                                    'dropdown-rotate' => 'Rotate',
                                ),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][search_form]',
                                'type' => 'select',
                                'label' => esc_html__('HEADER SEARCH FORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.search_form'),
                                'choices' => array(
                                    'disable' => 'Disable',
                                    'navbar-form' => 'Standard',
                                    'navbar-form-modern' => 'Modern',
                                ),
                                'description' => __('Disable search form or choose one of search form styles to display search icon on the right side of header area. THEMO gives you two different search form styles:</br><b> STANDARD</b> search form is a standard search field sliding down below header;</br><b>MODERN</b> search form slides down and cover whole header area.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][social_media]',
                                'type' => 'switcher',
                                'label' => esc_html__('SOCIAL MEDIA', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.social_media'),
                                'description' => __('Enable social media in header area. When you turn it on share icon will be displayed in header area. !!! Remember that if you are going to display social icons in header you should add social profiles to the site (go to SOCIAL MEDIA section in Customizer main panel and enter profile links to appropriate social media).', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][remove_language_switcher]',
                                'type' => 'switcher',
                                'label' => esc_html__('REMOVE LANGUAGE SWITCHER', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.remove_language_switcher'),
                                'description' => __('Turn off this option if you want to display languages icon in header area. ', 'themo'),
                                'depending' => array(
                                    'false' => array('ideo_theme_options[header][top][enable_language_shortcuts]')
                                ),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][enable_language_shortcuts]',
                                'type' => 'switcher',
                                'label' => esc_html__('ENABLE LANGUAGE SHORTCUTS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.enable_language_shortcuts'),
                                'description' => __('Enable this option if you want to display shortcuts (like EN, US etc.) instead of full languages names on the languages dropdown list. ', 'themo'),
                                'transport' => 'refresh',

                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][scroll_amount_input]',
                                'type' => 'slider',
                                'label' => esc_html__('SCROLL AMOUNT FOR STICKY SLIDE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.scroll_amount_input'),
                                'choices' => array(
                                    'min' => '150',
                                    'max' => '1000',
                                    'step' => '1',
                                ),
                                'description' => __('Decide after what scroll from the top of the page the sticky header slides down.</br><b>Notice that the Scroll amount for sticky slide should be bigger than the height of your header (calculated as the sum of the height of the Header, height of the Topbar and height of Header top distance).</b>', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][loading_effect]',
                                'type' => 'select',
                                'label' => esc_html__('STICKY HEADER LOADING EFFECT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.loading_effect'),
                                'choices' => array(
                                    '' => 'Disable',
                                    'loading-effect-1' => 'Style 1',
                                    'loading-effect-2' => 'Style 2',
                                ),
                                'description' => __('Sticky header loading effect is an additional effect for header - header background become a loading bar which loads smoothly while page scrolling. Disable Sticky header loading effect or enable this option by choosing one of loading styles: Style 1 (header border bottom loading); Style 2 (header background loading)', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][topbar_separator]',
                                'type' => 'separator',
                                'label' => esc_html__('TOPBAR', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][topbar][enabled]',
                                'type' => 'switcher',
                                'label' => esc_html__('TOPBAR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.topbar.enabled'),
                                'description' => __('Turn on this option to display topbar above header area. Notice that the content of the topbar is built using widgets in WordPress dashboard.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][topbar][height]',
                                'type' => 'slider',
                                'label' => esc_html__('TOPBAR HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.topbar.height'),
                                'choices' => array(
                                    'min' => '15',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][topbar_mobile]',
                                'type' => 'switcher',
                                'label' => esc_html__('SHOW ON MOBILE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.topbar_mobile'),
                                'description' => __('Turn on this option if you want to display topbar on mobile devices. Notice, that mobile topbar will be displayed only if you turn on topbar for header using option above.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][sticky]',
                        'title' => esc_html__('STYLING: Top/sticky headers', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][top][styling_separator]',
                                'type' => 'separator',
                                'label' => esc_html__('TOP HEADER STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][style]',
                                'type' => 'select',
                                'label' => esc_html__('TOP HEADER STYLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.style'),
                                'choices' => array(
                                    '' => 'Default',
                                    'colored-light' => 'Colored Light',
                                    'colored-dark' => 'Colored Dark',
                                    'transparent-light' => 'Transparent light',
                                    'transparent-dark' => 'Transparent dark',
                                ),
                                'description' => __('Choose global style for Top header. You can choose between Colored light, Colored dark, Transparent light and Transparent dark. Once you choose global header style you can colorize this style in appropriate coloring section below.</br> 
!!! Remember that with THEMO you can use different header styles on different pages. So if you are going to use more than one style over your website then colorize those styles in coloring sections below and than simply apply in Page options for those already colorized styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][width]',
                                'type' => 'select',
                                'label' => esc_html__('HEADER WIDTH', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.width'),
                                'choices' => array(
                                    '' => 'Full width',
                                    'container' => 'Boxed',
                                    'custom' => 'Custom',
                                ),
                                'depending' => array(
                                    'custom' => array('ideo_theme_options[header][top][custom_width]')
                                ),
                                'description' => __('Set Top header width (main header container with background). You can choose between Full width header (100% of screen width), Boxed (main content width) or choose Custom width to set precise header width in pixels.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][custom_width]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER CUSTOM WIDTH', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.custom_width'),
                                'choices' => array(
                                    'min' => '970',
                                    'max' => '1920',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][content_width]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER CONTENT WIDTH (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.content_width'),
                                'choices' => array(
                                    'min' => '970',
                                    'max' => '1920',
                                    'step' => '1',
                                ),
                                'description' => __('Set in pixels the width of Top header content (container with logo, menu and search).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][height]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER HEIGHT (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '200',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][logo][type]',
                                'type' => 'select',
                                'label' => esc_html__('LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.logo.type'),
                                'choices' => array(
                                    'none' => 'None',
                                    'normal' => 'Normal',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose logo for Top header (choose one of logo versions you have uploaded in logo section: Normal logo, Light logo or Dark logo).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][logo][height]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO HEIGHT (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.logo.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => __('Set logo height in pixels, logo will be scale with original apect ratio. Notice that logo height does not affect the height of the header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][logo][margin][top]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO MARGIN TOP (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.logo.margin.top'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => __('0 px value center logo inside header area but you can also enter other value to move logo from the top.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top][top_distance]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER TOP DISTANCE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top.top_distance'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '50',
                                    'step' => '1',
                                ),
                                'description' => __('Define in pixels header top distance. It makes empty space between header container and top edge of the screen.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][styling_separator]',
                                'type' => 'separator',
                                'label' => esc_html__('STICKY HEADER STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][style]',
                                'type' => 'select',
                                'label' => esc_html__('STICKY HEADER STYLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.style'),
                                'choices' => array(
                                    '' => 'Default',
                                    'colored-light' => 'Colored light',
                                    'colored-dark' => 'Colored dark',
                                    'transparent-light' => 'Transparent light',
                                    'transparent-dark' => 'Transparent dark',
                                ),
                                'description' => __('Choose global style for Sticky header. You can choose between Colored light, Colored dark, Transparent light and Transparent dark. Once you choose global header style you can colorize this style in appropriate coloring section below.</br> 
!!! Remember that with THEMO you can use different header styles on different pages. So if you are going to use more than one style over your website then colorize those styles in coloring sections below and than simply apply in Page options for those already colorized styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][width]',
                                'type' => 'select',
                                'label' => esc_html__('STICKY HEADER WIDTH', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.width'),
                                'choices' => array(
                                    '' => 'Full width',
                                    'container' => 'Boxed',
                                    'custom' => 'Custom',
                                ),
                                'depending' => array(
                                    'custom' => array('ideo_theme_options[header][sticky][custom_width]')
                                ),
                                'description' => __('Set Sticky header width (main header container with background). You can choose between Full width header (100% of screen width), Boxed (main content width) or choose Custom width to set precise header width in pixels.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][custom_width]',
                                'type' => 'slider',
                                'label' => esc_html__('STICKY CUSTOM HEADER WIDTH (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.custom_width'),
                                'choices' => array(
                                    'min' => '970',
                                    'max' => '1920',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][content_width]',
                                'type' => 'slider',
                                'label' => esc_html__('STICKY HEADER CONTENT WIDTH (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.content_width'),
                                'choices' => array(
                                    'min' => '970',
                                    'max' => '1920',
                                    'step' => '1',
                                ),
                                'description' => __('Set in pixels the width of Sticky header content (container with logo, menu and search).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][height]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER HEIGHT (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '200',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][logo][type]',
                                'type' => 'select',
                                'label' => esc_html__('STICKY LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.logo.type'),
                                'choices' => array(
                                    'none' => 'None',
                                    'normal' => 'Normal',
                                    'sticky.light' => 'Sticky light',
                                    'sticky.dark' => 'Sticky dark',
                                ),
                                'description' => __('Choose logo for Sticky header (choose one of logo versions you have uploaded in logo section: Normal logo, Sticky light logo or Sticky dark logo).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][logo][height]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.logo.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => __('Set logo height in pixels, logo will be scale with original apect ratio. Notice that logo height does not affect the height of the sticky header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][logo][margin][top]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO MARGIN TOP', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.logo.margin.top'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => __('0px value center logo inside sticky header area but you can also enter other value to move logo from the top of sticky header area.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][sticky][top_distance]',
                                'type' => 'slider',
                                'label' => esc_html__('STICKY HEADER TOP DISTANCE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.sticky.top_distance'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => __('Define in pixels Sticky header top distance. It makes empty space between sticky header container and top edge of the screen.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][side]',
                        'title' => esc_html__('SETTINGS: Side & offcanvas header', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][side][sideheader]',
                                'type' => 'separator',
                                'label' => esc_html__('SIDE HEADER', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][style]',
                                'type' => 'select',
                                'label' => esc_html__('SIDE HEADER STYLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side'),
                                'choices' => array(
                                    '' => 'Default',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose global style for Side header. You can choose between Light and Dark style. Once you choose global header style you can colorize this style in appropriate coloring section.</br>
!!! Remember that With THEMO you can use different header styles on different pages. So if you are going to use more than one style you can colorize both styles and than simply apply in Page options for one of those colorized styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][align][menu]',
                                'type' => 'select',
                                'label' => esc_html__('MENU ALIGN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.align.menu'),
                                'choices' => array(
                                    'left' => 'Left',
                                    'center' => 'Center',
                                    'right' => 'Right',
                                ),
                                'description' => __('Justify menu content to the Left, Center or Right side of the Side header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][align][bottom_area]',
                                'type' => 'select',
                                'label' => esc_html__('BOTTOM AREA ALIGN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.align.bottom_area'),
                                'choices' => array(
                                    'left' => 'Left',
                                    'center' => 'Center',
                                    'right' => 'Right',
                                ),
                                'description' => __('Justify bottom area content (social icons and copyrights) to the Left, Center and Right side of the Side header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][logo][type]',
                                'type' => 'select',
                                'label' => esc_html__('LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.logo.type'),
                                'choices' => array(
                                    'none' => 'None',
                                    'normal' => 'Normal',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose logo for Side header (choose one of logo versions you have uploaded in logo section: Normal logo, Light logo or Dark logo).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][logo][height]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.logo.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '300',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][logo][margin_left]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO MARGIN LEFT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.logo.margin_left'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '200',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][logo][margin_top]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO MARGIN TOP', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.logo.margin_top'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '200',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][logo][margin_bottom]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO MARGIN BOTTOM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.logo.margin_bottom'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '200',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][search_form]',
                                'type' => 'switcher',
                                'label' => esc_html__('HEADER SERCH FORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.search_form'),
                                'description' => __('Turn On or Off Search form displaying (search form shows just above menu).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][social_icon]',
                                'type' => 'switcher',
                                'label' => esc_html__('SOCIAL ICONS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.social_icon'),
                                'description' => __('Turn On or Off social icons displaying (social icons show at the bottom of the side header, just above copyrights). !!! Remember that if you are going to display social icons in header you should add social profiles to the site (go to SOCIAL MEDIA section in Customizer main panel and enter profile links to appropriate social media).', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][remove_language_switcher]',
                                'type' => 'switcher',
                                'label' => esc_html__('REMOVE LANGUAGE SWITCHER', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.remove_language_switcher'),
                                'description' => __('Turn off this option if you want to display languages icon in header area. ', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][copyright]',
                                'type' => 'textarea',
                                'multiline' => true,
                                'label' => esc_html__('COPYRIGHT TEXT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.copyright'),
                                'description' => __('Enter copyright text which will be displayed at the very bottom of Side header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas]',
                                'type' => 'separator',
                                'label' => esc_html__('OFFCANVAS', 'themo'),
                                'default' => '',
                                'description' => __('Enter copyright text which will be displayed at the very bottom of Side header.', 'themo'),
                                'transport' => 'postMessage',
                            ),

                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][topbar][type]',
                                'type' => 'radio',
                                'label' => esc_html__('OFFCANVAS BAR TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.topbar.type'),
                                'choices' => array(
                                    'hide' => esc_html__('Top', 'themo'),
                                    'sticky' => esc_html__('Sticky', 'themo'),                           
                                    'hide-slide' => esc_html__('Slide & hide', 'themo'),
                                ),
                                'description' => 'Choose off-canvas header type: </br> <strong>Top header</strong> – offcanvas bar stays at the top of the page </br> <strong>Sticky</strong> – offcanvas Top bar stays at the top of the page but the Sticky bar fade in right after scroll down. </br><strong>Slide and hide</strong> – offcanvas Top bar stays at the top of the page but the sticky bar do not appear and it is not visible when you scroll the page down, it will appear when you scroll up.',
                                'transport' => 'refresh',                                
                            ),                           
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][opening]',
                                'type' => 'select',
                                'label' => esc_html__('OPENING', 'themo'),
                                'default' => 'click',
                                'choices' => array(
                                    'click' => esc_html__('onClick', 'themo'),
                                    'hover' => esc_html__('Mouseover', 'themo'),
                                ),
                                'description' => __('Decide how the user call out the side header entrance:</br>   <strong>onClick</strong> – side header slide in when the user click on the menu icon; </br>  <strong>Mouseover</strong> – side header slide in when the user hover on the menu icon. </li>  </ul>', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][slide]',
                                'type' => 'switcher',
                                'label' => esc_html__('CONTENT SLIDE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.slide'),
                                'description' => __('Enable this option if you want your content moves side together with the entering side header. If it is disabled then side header simply cover the content.</br> !!! If you are using Parallax Composer layers with Relative to screen option then you shouldnt use Content slide option because while header sliding those layers will change theirs positions rapidly (css property) and it will be look badly. ', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][blur_content]',
                                'type' => 'switcher',
                                'label' => esc_html__('BLUR CONTENT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.blur_content'),
                                'depending' => array(
                                    'true' => array('ideo_theme_options[header][side][offcanvas][blur_strength]')
                                ),
                                'description' => __('Enable this option if you want to blur the content when the side header is displayed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][blur_strength]',
                                'type' => 'slider',
                                'label' => esc_html__('BLUR STRENGHT (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.blur_strength'),
                                'choices' => array(
                                    'min' => '1',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => __('', 'themo'),
                                'transport' => 'postMessage',
                            ),   
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][pagetitle][enabled]',
                                'type' => 'switcher',
                                'label' => esc_html__('ENABLE PAGETITLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.pagetitle.enabled'),                                
                                'depending' => array(
                                    'true' => array('ideo_theme_options[header][side][offcanvas][pagetitle][text]')
                                ),
                                'description' => __('Using this option you can display the title of the current page in the middle of the off-canvas bar. ', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][pagetitle][text]',
                                'type' => 'text',
                                'label' => esc_html__('HOMEPAGE TITLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.pagetitle.text'),
                                'description' => __('Type in the custom title for the homepage.', 'themo'),
                                'transport' => 'postMessage',
                            ),                                                        
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][icon_style]',
                                'type' => 'select',
                                'label' => esc_html__('ICON ANIMATION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.icon_style'),
                                'choices' => array(                                    
                                    'elastic' => 'elastic',
                                    'slider' => 'slider',
                                    'spin' => 'spin',
                                    'squeeze' => 'squeeze',
                                    'vortex' => 'vortex',
                                    'spring' => 'spring',
                                ),
                                'description' => __('', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][icon_size]',
                                'type' => 'visual-select',
                                'label' => esc_html__('ICON SIZE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.icon_size'),
                                'choices' => array(
                                    'small' => array(
                                        'title' => 'Icon Small',
                                        'image' => 'icon_size_1.png'
                                    ),                                    
                                    'medium' => array(
                                        'title' => 'Icon Medium',
                                        'image' => 'icon_size_3.png'
                                    ),                                    
                                    'large' => array(
                                        'title' => 'Icon Large',
                                        'image' => 'icon_size_4.png'
                                    ),
                                ),
                                'description' => '',
                                'transport' => 'postMessage',                                
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][topbar][style]',
                                'type' => 'select',
                                'label' => esc_html__('TOP BAR STYLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.topbar.style'),
                                'choices' => array(                                    
                                    '' => 'Default',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose global style for Top bar. You can choose between Light and Dark. Once you choose global bar header style you can colorize this style in appropriate coloring section below.</br>
!!! Remember that with THEMO you can use different header styles on different pages. So if you are going to use more than one style over your website then colorize those styles in coloring sections below and then simply apply in Page options for those already colorized styles.
', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][topbar][transparent]',
                                'type' => 'switcher',
                                'label' => esc_html__('TOP BAR TRANSPARENT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.topbar.transparent'),
                                'description' => __('', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][topbar][height]',
                                'type' => 'slider',
                                'label' => esc_html__('TOP BAR HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.topbar.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '200',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][topbar][logo][type]',
                                'type' => 'select',
                                'label' => esc_html__('TOP BAR LOGO', 'themo'),                                
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.topbar.logo.type'),
                                'choices' => array(
                                    'none' => 'None',
                                    'normal' => 'Normal',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),                               
                                'description' => __('', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][topbar][logo][height]',
                                'type' => 'slider',
                                'label' => esc_html__('TOP BAR LOGO HEIGHT (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.topbar.logo.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => __('Set logo height in pixels, logo will be scale with original aspect ratio. Notice that logo height does not affect the height of the bar.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][stickybar][style]',
                                'type' => 'select',
                                'label' => esc_html__('STICKY BAR STYLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.stickybar.style'),
                                'choices' => array(
                                    '' => 'Default',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose global style for Sticky bar. You can choose between Light and Dark. Once you choose global sticky header style you can colorize this style in appropriate coloring section below.</br>
!!! Remember that with THEMO you can use different header styles on different pages. So if you are going to use more than one style over your website then colorize those styles in coloring sections below and then simply apply in Page options for those already colorized styles.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][stickybar][height]',
                                'type' => 'slider',
                                'label' => esc_html__('STICKY BAR HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.stickybar.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '200',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][stickybar][logo][type]',
                                'type' => 'select',
                                'label' => esc_html__('STICKY BAR LOGO', 'themo'),                                
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.stickybar.logo.type'),
                                'choices' => array(
                                    'none' => 'None',
                                    'normal' => 'Normal',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),                               
                                'description' => __('', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][stickybar][logo][height]',
                                'type' => 'slider',
                                'label' => esc_html__('STICKY BAR LOGO HEIGHT (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.stickybar.logo.height'),
                                'choices' => array(
                                    'min' => '20',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => __('Set logo height in pixels, logo will be scale with original aspect ratio. Notice that logo height does not affect the height of the bar.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][mobile]',
                        'title' => esc_html__('SETTINGS: Mobile header', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][mobile][sticky]',
                                'type' => 'switcher',
                                'label' => esc_html__('ENABLE STICKY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.sticky'),
                                'description' => __('', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][header_skin]',
                                'type' => 'select',
                                'label' => esc_html__('HEADER SKIN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.header_skin'),
                                'choices' => array(
                                    '' => 'Default',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose between Light and Dark skin for Mobile header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][height]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER HEIGHT ', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.height'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][logo][type]',
                                'type' => 'select',
                                'label' => esc_html__('LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.logo.type'),
                                'choices' => array(
                                    'none' => 'None',
                                    'normal' => 'Normal',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose logo for Mobile header (choose one of logo versions you have uploaded in logo section: Normal logo, Light logo or Dark logo).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][logo][height_in_mobile_menu]',
                                'type' => 'slider',
                                'label' => esc_html__('LOGO HEIGHT IN MOBILE MENU', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.logo.height_in_mobile_menu'),
                                'choices' => array(
                                    'min' => '10',
                                    'max' => '100',
                                    'step' => '2',
                                ),
                                'description' => __('Set logo height in pixels, logo will be scale with original apect ratio. Notice that logo height does not affect the height of the mobile header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][search_bar]',
                                'type' => 'switcher',
                                'label' => esc_html__('ENABLE SEARCH BAR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.search_bar'),
                                'description' => __('Turn On or Off Search form for Mobile header.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][social_media_icon]',
                                'type' => 'switcher',
                                'label' => esc_html__('ENABLE SOCIAL MEDIA ICONS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.social_media_icon'),
                                'description' => __('Turn On or Off social icons displaying in Mobile header. !!! If you are gonna display social icons in header you should add social profiles to the site (go to SOCIAL MEDIA section in Customizer main panel and enter profile links to appropriate social media).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][remove_language_switcher]',
                                'type' => 'switcher',
                                'label' => esc_html__('REMOVE LANGUAGE SWITCHER', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.remove_language_switcher'),
                                'description' => __('Turn off this option if you want to display languages icon in header area. ', 'themo'),
                                'transport' => 'refresh',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][typography]',
                        'title' => esc_html__('FONTS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][typography][main_menu][seledyn]',
                                'type' => 'separator',
                                'label' => esc_html__('MAIN MENU', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][main_menu][font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.main_menu.font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][main_menu][font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.main_menu.font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][main_menu][font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.main_menu.font_weight'),
                                'depends' => 'ideo_theme_options[header][typography][main_menu][font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][main_menu][letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.main_menu.letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][main_menu][text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.main_menu.text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][submenu][seledyn]',
                                'type' => 'separator',
                                'label' => esc_html__('SUBMENU LEVEL 1 & LEVEL 2', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][submenu][font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.submenu.font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][submenu][line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.submenu.line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][submenu][font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.submenu.font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][submenu][font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.submenu.font_weight'),
                                'depends' => 'ideo_theme_options[header][typography][submenu][font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][submenu][letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.submenu.letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][submenu][text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.submenu.text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu][seledyn]',
                                'type' => 'separator',
                                'label' => esc_html__('MEGA MENU', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu][font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu.font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu][line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu.line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu][font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu.font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu][font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu.font_weight'),
                                'depends' => 'ideo_theme_options[header][typography][mega_menu][font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu][letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu.letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu][text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu.text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu_column_title][seledyn]',
                                'type' => 'separator',
                                'label' => esc_html__('MEGA MENU COLUMN TITLE', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu_column_title][font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu_column_title.font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu_column_title][line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu_column_title.line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu_column_title][font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu_column_title.font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu_column_title][font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu_column_title.font_weight'),
                                'depends' => 'ideo_theme_options[header][typography][mega_menu_column_title][font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu_column_title][letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu_column_title.letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mega_menu_column_title][text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mega_menu_column_title.text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu][seledyn]',
                                'type' => 'separator',
                                'label' => esc_html__('SIDE MENU LEVEL 1', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu][font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu.font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu][line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu.line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu][font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu.font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu][font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu.font_weight'),
                                'depends' => 'ideo_theme_options[header][typography][side_menu][font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu][letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu.letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu][text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu.text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu_submenu][seledyn]',
                                'type' => 'separator',
                                'label' => esc_html__('SIDE MENU LEVEL 2 & 3', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu_submenu][font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu_submenu.font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu_submenu][line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu_submenu.line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu_submenu][font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu_submenu.font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu_submenu][font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu_submenu.font_weight'),
                                'depends' => 'ideo_theme_options[header][typography][side_menu_submenu][font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu_submenu][letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu_submenu.letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][side_menu_submenu][text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.side_menu_submenu.text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mobile_menu][seledyn]',
                                'type' => 'separator',
                                'label' => esc_html__('MOBILE MENU', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mobile_menu][font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mobile_menu.font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mobile_menu][line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mobile_menu.line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mobile_menu][font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mobile_menu.font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mobile_menu][font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mobile_menu.font_weight'),
                                'depends' => 'ideo_theme_options[header][typography][mobile_menu][font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mobile_menu][letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mobile_menu.letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][typography][mobile_menu][text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.typography.mobile_menu.text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][top_sticky][colored][light]',
                        'title' => esc_html__('COLORING: Top/sticky - Colored light', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][sub_section_header]',
                                'type' => 'separator',
                                'label' => esc_html__('HEADER / MENU STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][border_bottom][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.border_bottom.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][border_bottom][thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.border_bottom.thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][first_level_menu_text][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('FIRST LEVEL MENU TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.first_level_menu_text.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][first_level_menu_text][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('FIRST LEVEL MENU TEXT HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.first_level_menu_text.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][hover_border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER STYLE 2 & 3 BORDER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.hover_border_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][hover_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER STYLE 4 & 5 BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.hover_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][search_language_icon_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH & LANGUAGE ICONS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.search_language_icon_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][search_language_icon_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH & LANGUAGE ICONS HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.search_language_icon_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][loading_effect1_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADING EFFECT 1 COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.loading_effect1_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][loading_effect2_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADING EFFECT 2 COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.loading_effect2_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][sub_section_mega_menu]',
                                'type' => 'separator',
                                'label' => esc_html__('SUB & MEGA MENU STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][mega_menu_sub_level][background][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.mega_menu_sub_level.background.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][mega_menu_sub_level][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.mega_menu_sub_level.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][mega_menu_sub_level][column_title_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLUMN TITLE COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.mega_menu_sub_level.column_title_color'),
                                'description' => __('This option refers to Mega menu only.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][mega_menu_sub_level][column_title][border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLUMN TITLE BORDER COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.mega_menu_sub_level.column_title.border_color'),
                                'description' => __('This option refers to Mega menu only.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][mega_menu_sub_level][text_icon][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT & ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.mega_menu_sub_level.text_icon.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][mega_menu_sub_level][text_icon][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT & ICON HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.mega_menu_sub_level.text_icon.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][mega_menu_sub_level][separators_color][horizontal]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HORIZONTAL SEPARATORS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.mega_menu_sub_level.separators_color.horizontal'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][mega_menu_sub_level][separators_color][vertical]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('VERTICAL SEPARATORS COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.mega_menu_sub_level.separators_color.vertical'),
                                'description' => __('This option refers to Mega menu columns separators.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][topbar_separator]',
                                'type' => 'separator',
                                'label' => esc_html__('TOPBAR STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][topbar][background]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.topbar.background'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][topbar][text]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.topbar.text'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][topbar][border_top_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER TOP THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.topbar.border_top_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][topbar][border_top_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER TOP COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.topbar.border_top_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][topbar][border_bottom_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.topbar.border_bottom_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][light][topbar][border_bottom_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.light.topbar.border_bottom_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][top_sticky][colored][dark]',
                        'title' => esc_html__('COLORING: Top/sticky - Colored dark', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][sub_section_header]',
                                'type' => 'separator',
                                'label' => esc_html__('HEADER / MENU STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][border_bottom][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.border_bottom.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][border_bottom][thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.border_bottom.thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][first_level_menu_text][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('FIRST LEVEL MENU TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.first_level_menu_text.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][first_level_menu_text][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('FIRST LEVEL MENU TEXT HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.first_level_menu_text.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][hover_border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER STYLE 2 & 3 BORDER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.hover_border_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][hover_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER STYLE 4 & 5 BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.hover_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][search_language_icon_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH & LANGUAGE ICONS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.search_language_icon_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][search_language_icon_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH & LANGUAGE ICONS HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.search_language_icon_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][loading_effect1_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADING EFFECT 1 COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.loading_effect1_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][loading_effect2_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADING EFFECT 2 COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.loading_effect2_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][sub_section_mega_menu]',
                                'type' => 'separator',
                                'label' => esc_html__('SUB & MEGA MENU STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][mega_menu_sub_level][background][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.mega_menu_sub_level.background.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][mega_menu_sub_level][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.mega_menu_sub_level.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][mega_menu_sub_level][column_title_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLUMN TITLE COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.mega_menu_sub_level.column_title_color'),
                                'description' => __('This option refers to Mega menu only.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][mega_menu_sub_level][column_title][border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLUMN TITLE BORDER COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.mega_menu_sub_level.column_title.border_color'),
                                'description' => __('This option refers to Mega menu only.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][mega_menu_sub_level][text_icon][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT & ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.mega_menu_sub_level.text_icon.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][mega_menu_sub_level][text_icon][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT & ICON HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.mega_menu_sub_level.text_icon.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][mega_menu_sub_level][separators_color][horizontal]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HORIZONTAL SEPARATORS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.mega_menu_sub_level.separators_color.horizontal'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][mega_menu_sub_level][separators_color][vertical]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('VERTICAL SEPARATORS COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.mega_menu_sub_level.separators_color.vertical'),
                                'description' => __('This option refers to Mega menu columns separators.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][topbar_separator]',
                                'type' => 'separator',
                                'label' => esc_html__('TOPBAR STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][topbar][background]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.topbar.background'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][topbar][text]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.topbar.text'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][topbar][border_top_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER TOP THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.topbar.border_top_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][topbar][border_top_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER TOP COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.topbar.border_top_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][topbar][border_bottom_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.topbar.border_bottom_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][colored][dark][topbar][border_bottom_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.colored.dark.topbar.border_bottom_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][top_sticky][transparent][light]',
                        'title' => esc_html__('COLORING: Top/sticky - Transparent light', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][sub_section_header]',
                                'type' => 'separator',
                                'label' => esc_html__('HEADER / MENU STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][border_bottom][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.border_bottom.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][border_bottom][thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.border_bottom.thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][first_level_menu_text][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('FIRST LEVEL MENU TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.first_level_menu_text.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][first_level_menu_text][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('FIRST LEVEL MENU TEXT HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.first_level_menu_text.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][hover_border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER STYLE 2 & 3 BORDER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.hover_border_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][hover_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER STYLE 4 & 5 BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.hover_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][search_language_icon_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH & LANGUAGE ICONS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.search_language_icon_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][search_language_icon_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH & LANGUAGE ICONS HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.search_language_icon_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][loading_effect1_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADING EFFECT 1 COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.loading_effect1_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][loading_effect2_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADING EFFECT 2 COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.loading_effect2_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][sub_section_mega_menu]',
                                'type' => 'separator',
                                'label' => esc_html__('SUB & MEGA MENU STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][mega_menu_sub_level][background][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.mega_menu_sub_level.background.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][mega_menu_sub_level][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.mega_menu_sub_level.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][mega_menu_sub_level][column_title_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLUMN TITLE COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.mega_menu_sub_level.column_title_color'),
                                'description' => __('This option refers to Mega menu only.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][mega_menu_sub_level][column_title][border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLUMN TITLE BORDER COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.mega_menu_sub_level.column_title.border_color'),
                                'description' => __('This option refers to Mega menu only.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][mega_menu_sub_level][text_icon][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT & ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.mega_menu_sub_level.text_icon.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][mega_menu_sub_level][text_icon][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT & ICON HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.mega_menu_sub_level.text_icon.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][mega_menu_sub_level][separators_color][horizontal]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HORIZONTAL SEPARATORS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.mega_menu_sub_level.separators_color.horizontal'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][mega_menu_sub_level][separators_color][vertical]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('VERTICAL SEPARATORS COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.mega_menu_sub_level.separators_color.vertical'),
                                'description' => __('This option refers to Mega menu columns separators.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][topbar_separator]',
                                'type' => 'separator',
                                'label' => esc_html__('TOPBAR STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][topbar][background]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.topbar.background'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][topbar][text]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.topbar.text'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][topbar][border_top_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER TOP THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.topbar.border_top_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][topbar][border_top_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER TOP COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.topbar.border_top_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][topbar][border_bottom_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.topbar.border_bottom_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][light][topbar][border_bottom_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.light.topbar.border_bottom_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][top_sticky][transparent][dark]',
                        'title' => esc_html__('COLORING: Top/sticky - Transparent dark', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][sub_section_header]',
                                'type' => 'separator',
                                'label' => esc_html__('HEADER / MENU STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][border_bottom][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.border_bottom.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][border_bottom][thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('HEADER BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.border_bottom.thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][first_level_menu_text][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('FIRST LEVEL MENU TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.first_level_menu_text.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][first_level_menu_text][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('FIRST LEVEL MENU TEXT HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.first_level_menu_text.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][hover_border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER STYLE 2 & 3 BORDER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.hover_border_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][hover_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER STYLE 4 & 5 BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.hover_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][search_language_icon_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH & LANGUAGE ICONS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.search_language_icon_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][search_language_icon_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH & LANGUAGE ICONS HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.search_language_icon_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][loading_effect1_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADING EFFECT 1 COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.loading_effect1_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][loading_effect2_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADING EFFECT 2 COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.loading_effect2_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][sub_section_mega_menu]',
                                'type' => 'separator',
                                'label' => esc_html__('SUB & MEGA MENU STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][mega_menu_sub_level][background][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.mega_menu_sub_level.background.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][mega_menu_sub_level][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HOVER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.mega_menu_sub_level.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][mega_menu_sub_level][column_title_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLUMN TITLE COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.mega_menu_sub_level.column_title_color'),
                                'description' => __('This option refers to Mega menu only.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][mega_menu_sub_level][column_title][border_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLUMN TITLE BORDER COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.mega_menu_sub_level.column_title.border_color'),
                                'description' => __('This option refers to Mega menu only.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][mega_menu_sub_level][text_icon][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT & ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.mega_menu_sub_level.text_icon.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][mega_menu_sub_level][text_icon][hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT & ICON HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.mega_menu_sub_level.text_icon.hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][mega_menu_sub_level][separators_color][horizontal]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HORIZONTAL SEPARATORS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.mega_menu_sub_level.separators_color.horizontal'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][mega_menu_sub_level][separators_color][vertical]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('VERTICAL SEPARATORS COLOR (MEGA MENU)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.mega_menu_sub_level.separators_color.vertical'),
                                'description' => __('This option refers to Mega menu columns separators.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][topbar_separator]',
                                'type' => 'separator',
                                'label' => esc_html__('TOPBAR STYLING', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][topbar][background]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.topbar.background'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][topbar][text]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.topbar.text'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][topbar][border_top_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER TOP THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.topbar.border_top_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][topbar][border_top_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER TOP COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.topbar.border_top_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][topbar][border_bottom_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.topbar.border_bottom_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][top_sticky][transparent][dark][topbar][border_bottom_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.top_sticky.transparent.dark.topbar.border_bottom_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][side][light][styling]',
                        'title' => esc_html__('COLORING: Side & offcanvas - Light', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][sideheader]',
                                'type' => 'separator',
                                'label' => esc_html__('SIDE HEADER', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][background]',
                                'type' => 'select',
                                'label' => esc_html__('SIDE HEADER BACKGROUND TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.background'),
                                'choices' => array(
                                    'color' => 'Color',
                                    'image' => 'Image',
                                ),
                                'description' => __('Choose Color or Image background type for side header. Depending on which option you choose appropriate options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                                'depending' => array(
                                    'color' => array(
                                        'ideo_theme_options[header][side][light][styling][color_background][background_color]',
                                        'ideo_theme_options[header][side][light][styling][color_background][pattern_overlay]',
                                        'ideo_theme_options[header][side][light][styling][color_background][pattern_color]'
                                    ),
                                    'image' => array(
                                        'ideo_theme_options[header][side][light][styling][image_background][background_image]',
                                        'ideo_theme_options[header][side][light][styling][image_background][image_position]',
                                        'ideo_theme_options[header][side][light][styling][image_background][image_size]',
                                        'ideo_theme_options[header][side][light][styling][image_background][image_repeat]',
                                        'ideo_theme_options[header][side][light][styling][image_background][image_overlay][type]'
                                    )
                                ),
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][color_background][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.color_background.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][color_background][pattern_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN  OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.color_background.pattern_overlay'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][color_background][pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.color_background.pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][image_background][background_image]',
                                'type' => 'upload',
                                'label' => esc_html__('BACKGROUND IMAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.image_background.background_image'),
                                'description' => __('Upload image which will be set as a background. Only .jpg .png .bmp formats are allowed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][image_background][image_position]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE POSITION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.image_background.image_position'),
                                'choices' => array(
                                    'top_left' => 'Top left',
                                    'top_center' => 'top center',
                                    'top_right' => 'top right',
                                    'center_left' => 'Center left',
                                    'center_center' => 'Center center',
                                    'center_right' => 'Center right',
                                    'bottom_left' => 'Bottom left',
                                    'bottom_center' => 'Bottom center',
                                    'bottom_right' => 'Bottom right',
                                ),
                                'description' => __('Choose image position property to set the starting position of background image.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][image_background][image_size]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE SIZE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.image_background.image_size'),
                                'choices' => array(
                                    'auto' => 'no scale',
                                    'cover' => 'cover',
                                    'contain' => 'container',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][image_background][image_repeat]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE REPEAT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.image_background.image_repeat'),
                                'choices' => array(
                                    'no_repeat' => 'No repeat',
                                    'repeat_x' => 'Repeat X',
                                    'repeat_y' => 'Repeat Y',
                                    'repeat' => 'Repeat XY',
                                ),
                                'description' => __('Choose image repeat property to set if/how the background image will be repeated.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][image_background][image_overlay][type]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.image_background.image_overlay.type'),
                                'choices' => array(
                                    'none' => 'none',
                                    'color' => 'color',
                                    'pattern' => 'pattern',
                                ),
                                'description' => __('Choose Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose appropriate styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                                'depending' => array(
                                    'none' => array(),
                                    'color' => array(
                                        'ideo_theme_options[header][side][light][styling][image_background][image_overlay][color][pattern_color]'
                                    ),
                                    'pattern' => array(
                                        'ideo_theme_options[header][side][light][styling][image_background][image_overlay][pattern][type]',
                                        'ideo_theme_options[header][side][light][styling][image_background][image_overlay][pattern][color]'
                                    )
                                ),
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][image_background][image_overlay][color][pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.image_background.image_overlay.color.pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][image_background][image_overlay][pattern][type]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.image_background.image_overlay.pattern.type'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][image_background][image_overlay][pattern][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.image_background.image_overlay.pattern.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][menu_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.menu_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][menu_text_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU TEXT HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.menu_text_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][separators_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEPARATORS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.separators_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][dropdown_menu_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('DROPDOWN MENU BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.dropdown_menu_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][search_input_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH INPUT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.search_input_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][search_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.search_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][social_icon_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SOCIAL ICONS BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.social_icon_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][social_icons_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SOCIAL ICONS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.social_icons_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][copyrights]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COPYRIGHTS TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.light.styling.copyrights'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][light][styling][offcanvas]',
                                'type' => 'separator',
                                'label' => esc_html__('OFFCANVAS', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][light][styling][bar][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BAR BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.light.styling.bar.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][light][styling][bar][border_bottom_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.light.styling.bar.border_bottom_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][light][styling][bar][border_bottom_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.light.styling.bar.border_bottom_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][light][styling][menu_icon]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.light.styling.menu_icon'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][light][styling][menu_icon_hover]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU ICON HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.light.styling.menu_icon_hover'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][light][styling][pagetitle]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BAR PAGE TITLE COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.light.styling.pagetitle'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][light][styling][overlay]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('CONTENT OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.light.styling.overlay'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][side][dark][styling]',
                        'title' => esc_html__('COLORING: Side & offcanvas - Dark', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][sideheader]',
                                'type' => 'separator',
                                'label' => esc_html__('SIDE HEADER', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][background]',
                                'type' => 'select',
                                'label' => esc_html__('SIDE HEADER BACKGROUND TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.background'),
                                'choices' => array(
                                    'color' => 'Color',
                                    'image' => 'Image',
                                ),
                                'description' => __('Choose Color or Image background type for side header. Depending on which option you choose appropriate options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                                'depending' => array(
                                    'color' => array(
                                        'ideo_theme_options[header][side][dark][styling][color_background][background_color]',
                                        'ideo_theme_options[header][side][dark][styling][color_background][pattern_overlay]',
                                        'ideo_theme_options[header][side][dark][styling][color_background][pattern_color]'
                                    ),
                                    'image' => array(
                                        'ideo_theme_options[header][side][dark][styling][image_background][background_image]',
                                        'ideo_theme_options[header][side][dark][styling][image_background][image_position]',
                                        'ideo_theme_options[header][side][dark][styling][image_background][image_size]',
                                        'ideo_theme_options[header][side][dark][styling][image_background][image_repeat]',
                                        'ideo_theme_options[header][side][dark][styling][image_background][image_overlay][type]'
                                    )
                                ),
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][color_background][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('HEADER BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.color_background.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][color_background][pattern_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN  OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.color_background.pattern_overlay'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][color_background][pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.color_background.pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][image_background][background_image]',
                                'type' => 'upload',
                                'label' => esc_html__('BACKGROUND IMAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.image_background.background_image'),
                                'description' => __('Upload image which will be set as a background. Only .jpg .png .bmp formats are allowed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][image_background][image_position]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE POSITION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.image_background.image_position'),
                                'choices' => array(
                                    'top_left' => 'Top left',
                                    'top_center' => 'top center',
                                    'top_right' => 'top right',
                                    'center_left' => 'Center left',
                                    'center_center' => 'Center center',
                                    'center_right' => 'Center right',
                                    'bottom_left' => 'Bottom left',
                                    'bottom_center' => 'Bottom center',
                                    'bottom_right' => 'Bottom right',
                                ),
                                'description' => __('Choose image position property to set the starting position of background image.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][image_background][image_size]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE SIZE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.image_background.image_size'),
                                'choices' => array(
                                    'auto' => 'no scale',
                                    'cover' => 'cover',
                                    'contain' => 'container',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][image_background][image_repeat]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE REPEAT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.image_background.image_repeat'),
                                'choices' => array(
                                    'no_repeat' => 'No repeat',
                                    'repeat_x' => 'Repeat X',
                                    'repeat_y' => 'Repeat Y',
                                    'repeat' => 'Repeat XY',
                                ),
                                'description' => __('Choose image repeat property to set if/how the background image will be repeated.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][image_background][image_overlay][type]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.image_background.image_overlay.type'),
                                'choices' => array(
                                    'none' => 'none',
                                    'color' => 'color',
                                    'pattern' => 'pattern',
                                ),
                                'description' => __('Choose Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose several styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                                'depending' => array(
                                    'none' => array(),
                                    'color' => array(
                                        'ideo_theme_options[header][side][dark][styling][image_background][image_overlay][color][pattern_color]'
                                    ),
                                    'pattern' => array(
                                        'ideo_theme_options[header][side][dark][styling][image_background][image_overlay][pattern][type]',
                                        'ideo_theme_options[header][side][dark][styling][image_background][image_overlay][pattern][color]'
                                    )
                                ),
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][image_background][image_overlay][color][pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.image_background.image_overlay.color.pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][image_background][image_overlay][pattern][type]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.image_background.image_overlay.pattern.type'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),

                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][image_background][image_overlay][pattern][color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.image_background.image_overlay.pattern.color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][menu_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.menu_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][menu_text_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU TEXT HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.menu_text_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][separators_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEPARATORS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.separators_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][dropdown_menu_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('DROPDOWN MENU BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.dropdown_menu_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][search_input_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH INPUT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.search_input_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][search_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.search_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][social_icon_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SOCIAL ICONS BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.social_icon_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][social_icons_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SOCIAL ICONS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.social_icons_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][dark][styling][copyrights]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COPYRIGHTS TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.dark.styling.copyrights'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][dark][styling][offcanvas]',
                                'type' => 'separator',
                                'label' => esc_html__('OFFCANVAS', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][dark][styling][bar][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BAR BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.dark.styling.bar.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][dark][styling][bar][border_bottom_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER BOTTOM THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.dark.styling.bar.border_bottom_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '10',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][dark][styling][bar][border_bottom_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BORDER BOTTOM COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.dark.styling.bar.border_bottom_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][dark][styling][menu_icon]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.dark.styling.menu_icon'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                                array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][dark][styling][menu_icon_hover]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU ICON HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.dark.styling.menu_icon_hover'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                                array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][dark][styling][pagetitle]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BAR PAGE TITLE COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.dark.styling.pagetitle'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][side][offcanvas][dark][styling][overlay]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('CONTENT OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.side.offcanvas.dark.styling.overlay'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][mobile][light][styling]',
                        'title' => esc_html__('COLORING: Mobile header - Light', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MOBILE MENU BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][border_top_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__(' MENU TOP BORDER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.border_top_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][border_top_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER TOP THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.border_top_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '5',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][icon_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.icon_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][first_dropdown_background]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('1st DROPDOWN BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.first_dropdown_background'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][second_dropdown_background]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('2-3rd DROPDOWN BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.second_dropdown_background'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][text_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.text_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][separators_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEPARATORS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.separators_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][search_input_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH INPUT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.search_input_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][search_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.search_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][light][styling][topbar_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TOPBAR BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.light.styling.topbar_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'ideo_theme_options[header][mobile][dark][styling]',
                        'title' => esc_html__('COLORING: Mobile header - Dark', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MOBILE MENU BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][border_top_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__(' MENU TOP BORDER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.border_top_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][border_top_thickness]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER TOP THICKNESS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.border_top_thickness'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '5',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][icon_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('MENU ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.icon_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][first_dropdown_background]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('1st DROPDOWN BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.first_dropdown_background'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][second_dropdown_background]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('2-3rd DROPDOWN BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.second_dropdown_background'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][text_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.text_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][separators_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEPARATORS COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.separators_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][search_input_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH INPUT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.search_input_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][search_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('SEARCH TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.search_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[header][mobile][dark][styling][topbar_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TOPBAR BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.mobile.dark.styling.topbar_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                ),
            );