<?php 
$settings[] =  array(
                'id' => 'generals',
                'title' => esc_html__('GENERALS', 'themo'),
                'sections' => array(
                    array(
                        'id' => 'layout',
                        'title' => esc_html__('LAYOUT', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[generals][layout][layout_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('In Layout section you can decide to use Boxed layout or Wide layout and set custom width of page content.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][layout][boxed_version]',
                                'type' => 'switcher',
                                'label' => esc_html__('BOXED VERSION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.layout.boxed_version'),
                                'description' => __('By default Wide layout is in use, so your content is able to cover full width of the page (only one fullwidth background is in use). Turn On Boxed version and your content will be fitted in a centrally positioned grid (you could set one background for content area and second background for outer area).', 'themo'),
                                'transport' => 'refresh',
                                'depending' => array(
                                    'true' => array(),
                                    'false' => array('ideo_theme_options[header][top][width]', 'ideo_theme_options[header][top][custom_width]', 'ideo_theme_options[header][sticky][width]', 'ideo_theme_options[header][sticky][custom_width]')
                                ),
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][layout][site_width]',
                                'type' => 'slider',
                                'label' => esc_html__('SITE WIDTH', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.layout.site_width'),
                                'choices' => array(
                                    'min' => '900',
                                    'max' => '1440',
                                    'step' => '1',
                                ),
                                'description' => __('Define content area width in pixels.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'styling',
                        'title' => esc_html__('STYLING', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[generals][styling][info_styling]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.styling.info_styling'),
                                'description' => __('In this section you can customize main styling (coloring) options which will be used over your whole site.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][styling][theme_skin]',
                                'type' => 'select',
                                'label' => esc_html__('THEME SKIN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.styling.theme_skin'),
                                'choices' => array(
                                    'light' => 'LIGHT',
                                    'dark' => 'DARK',
                                ),
                                'description' => __('Choose global theme skin. This option affects globally for default styles and skins of every single page element on your website (Background, Fonts, Header, Page title  Fonts skin, Header skin, Page title skin, Shortcodes, Footer, Sidebar). Naturally, you can override styles and skins for every page element separately in appropriate Customizer sections (globally) or in Page options (for every single page or post).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][styling][accent_color]',
                                'type' => 'select',
                                'label' => esc_html__('ACCENT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.styling.accent_color'),
                                'choices' => array(
                                    '#3498db' => 'Themo',
                                    '#96dcde' => 'Limper shell',
                                    '#9897a3' => 'Lilac grey',
                                    '#f97c6a' => 'Peach echo',
                                    '#76c453' => 'Green flash',
                                    '#fadd3b' => 'Butter cup',
                                    '#b28f6a' => 'Iced coffee',
                                    '#df4831' => 'Fiesta',
                                    '#005185' => 'Snorkel blue',
                                    '#90a9d0' => 'Serenity',
                                    'custom' => 'CUSTOM',
                                ),
                                'depending' => array(
                                    'custom' => array('ideo_theme_options[generals][styling][custom_accent_color]'),
                                ),
                                'description' => __('Choose one of predefined accent colors or choose Custom to define your own accent color. Accent color will affect over the whole site but you can override it for particular elements using Customizer, Page, Post and shortcodes options.', 'themo'),
                                'transport' => 'both',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][styling][custom_accent_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('CUSTOM ACCENT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.styling.custom_accent_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'background',
                        'title' => esc_html__('BACKGROUND', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'separator_background_content',
                                'type' => 'separator',
                                'label' => esc_html__('CONTENT BACKGROUND', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_info'),
                                'description' => __('In this section you can set and customize content background for your whole site (it will be used as default background on every page you will add but naturally you can override global settings for every single page using Page options). Notice, that Content background settings refer to both layout versions: Wide layout background and Boxed layout background.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_type]',
                                'type' => 'select',
                                'label' => esc_html__('CONTENT BACKGROUND TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_type'),
                                'choices' => array(
                                    '' => 'Default',
                                    'color' => 'Color',
                                    'image' => 'Image',
                                ),
                                'depending' => array(
                                    'color' => array('ideo_theme_options[generals][background][content_background_color]', 'ideo_theme_options[generals][background][content_background_color_overlay]'),
                                    'image' => array('ideo_theme_options[generals][background][content_background_upload_image]', 'ideo_theme_options[generals][background][content_background_cover]', 'ideo_theme_options[generals][background][content_background_image_position]', 'ideo_theme_options[generals][background][content_background_image_repeat]', 'ideo_theme_options[generals][background][content_background_image_motion]', 'ideo_theme_options[generals][background][content_background_image_overlay]'),
                                ),
                                'description' => __('Choose Color or Image background type for content area. Depending on which option you choose appropriate options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_color_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_color_overlay'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[generals][background][content_background_color_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[generals][background][content_background_color_pattern]', 'ideo_theme_options[generals][background][content_background_color_pattern_color]'),
                                ),
                                'description' => __('Choose between Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose the several styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_color_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_color_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_color_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_color_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_color_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_color_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_upload_image]',
                                'type' => 'upload',
                                'label' => esc_html__('UPLOAD IMAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_upload_image'),
                                'description' => __('Upload image which will be set as a background. .jpg .png .bmp formats are allowed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_cover]',
                                'type' => 'switcher',
                                'label' => esc_html__('100% BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_cover'),
                                'description' => __('Turn On this option to set COVER property for background image size (it will be scale to be as large as possible so that the background area is completely covered by the background image). By default this option is turned Off, so background image size has set <i>auto</i> property (original width and height).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_image_position]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE POSITION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_image_position'),
                                'choices' => array(
                                    'left_top' => 'Left top',
                                    'center_top' => 'Center top',
                                    'right_top' => 'Right top',
                                    'left_center' => 'Left center',
                                    'center_center' => 'Center center',
                                    'right_center' => 'Right center',
                                    'left_bottom' => 'Left bottom',
                                    'center_bottom' => 'Center bottom',
                                    'right_bottom' => 'Right bottom',
                                ),
                                'description' => __('Choose image position property to set the starting position of background image.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_image_repeat]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE REPEAT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_image_repeat'),
                                'choices' => array(
                                    'no_repeat' => 'No repeat',
                                    'repeat_x' => 'Repeat X',
                                    'repeat_y' => 'Repeat Y',
                                    'repeat' => 'Repeat XY',
                                ),
                                'description' => __('Choose image repeat property to set if/how the background image will be repeated.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_image_motion]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE MOTION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_image_motion'),
                                'choices' => array(
                                    'scroll' => 'Scroll',
                                    'fixed' => 'Fixed',
                                ),
                                'description' => __('Choose background image motion type: Scroll means that the background image scrolls along with all page elements, Fixed means that the background image is fixed with regard to the viewport.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_image_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_image_overlay'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[generals][background][content_background_image_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[generals][background][content_background_image_overlay_pattern]', 'ideo_theme_options[generals][background][content_background_image_overlay_pattern_color]'),
                                ),
                                'description' => __('Choose Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose several styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_image_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_image_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_image_overlay_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_image_overlay_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][content_background_image_overlay_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.content_background_image_overlay_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'separator_background_boxed',
                                'type' => 'separator',
                                'label' => esc_html__('OUTER AREA BACKGROUND', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_info'),
                                'description' => __('In this section you can set and customize outer area background. It is the background which is displayed behind the Content background. <b>Notice that, Outer area background will be in use only for Boxed layout.</b>', 'themo'),
                                'transport' => 'refresh',
                            ),

                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_type]',
                                'type' => 'select',
                                'label' => esc_html__('OUTER AREA BACKGROUND TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_type'),
                                'choices' => array(
                                    '' => 'Default',
                                    'color' => 'Color',
                                    'image' => 'Image',
                                ),
                                'depending' => array(
                                    'color' => array('ideo_theme_options[generals][background][boxed_background_color]', 'ideo_theme_options[generals][background][boxed_background_color_overlay]'),
                                    'image' => array('ideo_theme_options[generals][background][boxed_background_upload_image]', 'ideo_theme_options[generals][background][boxed_background_cover]', 'ideo_theme_options[generals][background][boxed_background_image_position]', 'ideo_theme_options[generals][background][boxed_background_image_repeat]', 'ideo_theme_options[generals][background][boxed_background_image_motion]', 'ideo_theme_options[generals][background][boxed_background_image_overlay]')
                                ),
                                'description' => __('Choose Color or Image background type for outer area. Depending on which option you choose appropriate options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_color_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_color_overlay'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[generals][background][boxed_background_color_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[generals][background][boxed_background_color_pattern]', 'ideo_theme_options[generals][background][boxed_background_color_pattern_color]'),
                                ),
                                'description' => __('Choose between Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose the several styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_color_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_color_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_color_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_color_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_color_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_color_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_upload_image]',
                                'type' => 'upload',
                                'label' => esc_html__('UPLOAD IMAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_upload_image'),
                                'description' => __('Upload image which will be set as a background. Only .jpg .png .bmp formats are allowed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_cover]',
                                'type' => 'switcher',
                                'label' => esc_html__('100% BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_cover'),
                                'description' => __('Turn On this option to set COVER property for background image size (it will be scale to be as large as possible so that the background area is completely covered by the background image). By default this option is turned Off, so background image size has set <i>auto</i> property (original width and height).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_image_position]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE POSITION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_image_position'),
                                'choices' => array(
                                    'left_top' => 'Left top',
                                    'center_top' => 'Center top',
                                    'right_top' => 'Right top',
                                    'left_center' => 'Left center',
                                    'center_center' => 'Center center',
                                    'right_center' => 'Right center',
                                    'left_bottom' => 'Left bottom',
                                    'center_bottom' => 'Center bottom',
                                    'right_bottom' => 'Right bottom',
                                ),
                                'description' => __('Choose image position property to set the starting position of background image.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_image_repeat]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE REPEAT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_image_repeat'),
                                'choices' => array(
                                    'no_repeat' => 'No repeat',
                                    'repeat_x' => 'Repeat X',
                                    'repeat_y' => 'Repeat Y',
                                    'repeat' => 'Repeat XY',
                                ),
                                'description' => __('Choose image repeat property to set if/how the background image will be repeated.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_image_motion]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE MOTION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_image_motion'),
                                'choices' => array(
                                    'scroll' => 'Scroll',
                                    'fixed' => 'Fixed',
                                ),
                                'description' => __('Choose background image motion type: Scroll means that the background image scrolls along with all page elements, Fixed means that the background image is fixed with regard to the viewport.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_image_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_image_overlay'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[generals][background][boxed_background_image_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[generals][background][boxed_background_image_overlay_pattern]', 'ideo_theme_options[generals][background][boxed_background_image_overlay_pattern_color]'),
                                ),
                                'description' => __('Choose Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose several styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_image_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_image_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_image_overlay_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_image_overlay_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][background][boxed_background_image_overlay_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.background.boxed_background_image_overlay_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'advanced_advanced',
                        'title' => esc_html__('SETTINGS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[header][logo][favicon]',
                                'type' => 'upload',
                                'label' => esc_html__('FAVICON', 'themo'),
                                'default' => ideothemo_get_themo_default_value('header.logo.favicon'),
                                'description' => __('Upload favicon which will be displayed in the browser address tab (next to the page title).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_advanced][advanced_gm_api_key]',
                                'type' => 'text',
                                'label' => esc_html__('GOOGLE MAPS KEY API ', 'themo'),
                                'default' => '',
                                'description' => __('Enter Google Maps API KEY.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_advanced][advanced_head_tags]',
                                'type' => 'textarea',
                                'multiline' => true,
                                'label' => esc_html__('HEAD TAGS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_advanced.advanced_head_tags'),
                                'description' => __('Enter html tags which you want to add to head section. All tags will be placed just before /head tag.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_advanced][advanced_body_tags]',
                                'type' => 'textarea',
                                'multiline' => true,
                                'label' => esc_html__('BODY TAGS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_advanced.advanced_body_tags'),
                                'description' => __('Enter html tags which you want to add to body section. All tags will be placed just before /body tag.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'general_smoothscroll',
                        'title' => esc_html__('SMOOTHSCROLL', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[generals][general_smoothscroll][smoothscroll_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'description' => __('Themo allows you to choose a type of page scrolling. You can use classic scroll or choose one of Smooth scroll methods. Selecting the scroll method is a very individual and subjective matter, so you should try each type and choose the one that best suits to your site. Scroll type is particularly important if you are going to create animations in Parallax Composer because different scroll types allows you to create totally different effects.</br> Firefox and Internet Explorer browsers do not support Smooth scroll for websites, so if you are going to use this type, you should check how it works on different browsers because on FF and IE ideoSmoothscroll will be set in place of Smooth scroll for websites.', 'themo'),
                                'transport' => 'refresh',
                            ),

                            array(
                                'id' => 'ideo_theme_options[generals][general_smoothscroll][smoothscrolling]',
                                'type' => 'select',
                                'label' => esc_html__('SMOOTHSCROLLING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.general_smoothscroll.smoothscrolling'),
                                'choices' => array(
                                    'none' => 'None',
                                    'ideosmooth' => 'ideoSmoothScroll',
                                    'scroll4websites' => 'Smoothscroll for websites',
                                ),
                                'depending' => array(
                                    'scroll4websites' => array('ideo_theme_options[generals][general_smoothscroll][smoothscroll_preset]', 'ideo_theme_options[generals][general_smoothscroll][smoothscroll_ieff]')
                                ),
                                'description' => __('', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[generals][general_smoothscroll][smoothscroll_preset]',
                                'type' => 'select',
                                'label' => esc_html__('SMOOTHSCROLL PRESET', 'themo'),
                                'default' => ideothemo_get_themo_default_value('generals.general_smoothscroll.smoothscroll_preset'),
                                'choices' => array(
                                    'longtail' => 'Long tail',
                                    'mediumtail' => 'Medium tail',
                                    'shorttail' => 'Short tail',
                                    'dynamic' => 'Dynamic',
                                    'dynamic2' => 'Dynamic 2',
                                ),
                                'description' => __('', 'themo'),
                                'transport' => 'refresh',
                            ),
                        ),
                    ),
                ),
            );