<?php 
$settings[] = array(
                'id' => 'footer',
                'title' => esc_html__('FOOTER', 'themo'),
                'sections' => array(
                    array(
                        'id' => 'footer_settings',
                        'title' => esc_html__('SETTINGS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][footer-separator]',
                                'type' => 'separator',
                                'label' => esc_html__('FOOTER', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][footer_on]',
                                'type' => 'switcher',
                                'label' => esc_html__('FOOTER', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.footer_on'),
                                'description' => __('Turn On or Off Footer displaying on your site.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][footer_type]',
                                'type' => 'select',
                                'label' => esc_html__('FOOTER TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.footer_type'),
                                'choices' => array(
                                    'standard' => 'Standard',
                                    'advanced' => 'Advanced',
                                ),
                                'depending' => array(
                                    'standard' => array('ideo_theme_options[footer][footer_settings][standard_footer_skin]', 'ideo_theme_options[footer][footer_settings][breadcrumbs-separator]', 'ideo_theme_options[footer][footer_settings][copywrite_area_on]', 'ideo_theme_options[footer][footer_settings][copyright_skin]', 'ideo_theme_options[footer][footer_settings][copyright_paddings]', 'ideo_theme_options[footer][footer_settings][copyright_text]', 'ideo_theme_options[footer][footer_settings][copyright_text_align]'),
                                    'advanced' => array('ideo_theme_options[footer][footer_settings][choose_advanced_footer]'),
                                ),
                                'description' => __('Choose global footer. THEMO gives you 2 different footer types based on two different content builders. Depending on which options you choose several options will be available below. If you choose Standard footer choose its skin and use following options to customize its appearance. If you choose Advanced footer simply choose from dropdown one of footers you have created. 
</br><b>Standard footer</b> based on  WordPress widgets, to build Standard footer content use widgets available in Appearance/Widgets section in WordPress dashboard. To customize Standard footer appearance use below options, customize standard footer skin, layout, background, colors, fonts and of course copyright area. 
</br><b>Advanced footer</b> based on Visual Composer page builder, you can build Advanced footer content and customize its appearance using section and all THEMO shortcodes. Go to Footer section in WordPress dashboard and see how simple it is. You can build as many Advanced footer as you need.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][standard_footer_skin]',
                                'type' => 'select',
                                'label' => esc_html__('STANDARD FOOTER SKIN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.standard_footer_skin'),
                                'choices' => array(
                                    '' => 'Default',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Pick global footer skin. You can choose between Light and Dark skin. Light skin means light content (fonts) and Dark skin means dark content (fonts). Choose Default if you want to use default skin.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][choose_advanced_footer]',
                                'type' => 'select',
                                'label' => esc_html__('CHOOSE ADVANCED FOOTER', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.choose_advanced_footer'),
                                'choices' => array('' => esc_html__('Choose', 'themo')) + ideothemo_get_footers(),

                                'description' => __('Choose one of Advanced footer you have already created. If you have not created any Advanced footer yet go to WordPress dashboard, find Footer section and click Add new.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][sticky_footer]',
                                'type' => 'switcher',
                                'label' => esc_html__('STICKY FOOTER', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.sticky_footer'),
                                'description' => __('Turn On or Off sticky footer effect. When it is turned ON footer is hidden behind main content background and it gradually appears while scrolling.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][breadcrumbs-separator]',
                                'type' => 'separator',
                                'label' => esc_html__('COPYRIGHTS', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][copywrite_area_on]',
                                'type' => 'switcher',
                                'label' => esc_html__('COPYRIGHT AREA', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.copywrite_area_on'),
                                'description' => __('Turn On or Off Copyrights area displaying on your site.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][copyright_skin]',
                                'type' => 'select',
                                'label' => esc_html__('COPYRIGHT SKIN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.copyright_skin'),
                                'choices' => array(
                                    '' => 'Default',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Pick global Copyrights skin. You can choose between Light and Dark skin of Copyright area. Light skin means light background/dark content and Dark skin means dark background/light content. Choose Default if you want to use default skin.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][copyright_paddings]',
                                'type' => 'slider',
                                'label' => esc_html__('COPYRIGHTS PADDING TOP & BOTTOM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.copyright_paddings'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][copyright_text]',
                                'type' => 'textarea',
                                'multiline' => true,
                                'label' => esc_html__('COPYRIGHTS TEXT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.copyright_text'),
                                'description' => __('Enter copyrights content here. HTML tags are allowed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][footer_settings][copyright_text_align]',
                                'type' => 'select',
                                'label' => esc_html__('COPYRIGHTS TEXT ALIGN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.footer_settings.copyright_text_align'),
                                'choices' => array(
                                    'left' => 'Left',
                                    'center' => 'Center',
                                    'right' => 'Right',
                                ),
                                'description' => __('Justify copyright text to the Left, Center or Right side of copyright area.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'standard_footer_layout',
                        'title' => esc_html__('STANDARD FOOTER LAYOUT', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_layout][footer_layout]',
                                'type' => 'select',
                                'label' => esc_html__('FOOTER & COPYRIGHTS LAYOUT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_layout.footer_layout'),
                                'choices' => array(
                                    'in_grid' => 'In grid',
                                    'full_width' => 'Full width',
                                    'custom' => 'Custom',
                                ),
                                'depending' => array(
                                    'in_grid' => array(''),
                                    'full_width' => array(''),
                                    'custom' => array('ideo_theme_options[footer][standard_footer_layout][footer_custom_layout]'),
                                ),
                                'description' => __('Choose between In grid, Fullwidth or Custom footer layout. If you choose In grid then the footer content get main content width. If you choose Fullwidth then footer content gets full screen width. If you choose Custom then you will be able to define in pixels precise width of footer content (Custom layout option will be available below).', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_layout][footer_custom_layout]',
                                'type' => 'slider',
                                'label' => esc_html__('CUSTOM LAYOUT WIDTH', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_layout.footer_custom_layout'),
                                'choices' => array(
                                    'min' => '960',
                                    'max' => '1900',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_layout][footer_columns]',
                                'type' => 'select',
                                'label' => esc_html__('FOOTER COLUMNS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_layout.footer_columns'),
                                'choices' => array(
                                    '100' => '100%',
                                    '50_50' => '50-50%',
                                    '66_34' => '66-34%',
                                    '34_66' => '34-66%',
                                    '33_34_33' => '33-34-33%',
                                    '25_25_50' => '25-25-50%',
                                    '50_25_25' => '50-25-25%',
                                    '25_25_25_25' => '25-25-25-25%',
                                ),
                                'description' => __('Specify number and width of footer columns.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_layout][footer_padding_top]',
                                'type' => 'slider',
                                'label' => esc_html__('PADDING TOP', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_layout.footer_padding_top'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '150',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_layout][footer_padding_bottom]',
                                'type' => 'slider',
                                'label' => esc_html__('PADDING BOTTOM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_layout.footer_padding_bottom'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '150',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'standard_footer_background',
                        'title' => esc_html__('STANDARD FOOTER BACKGROUND', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_type]',
                                'type' => 'select',
                                'label' => esc_html__('BACKGROUND TYPE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_type'),
                                'choices' => array(
                                    '' => 'Default',
                                    'color' => 'Color',
                                    'image' => 'Image',
                                ),
                                'depending' => array(
                                    'default' => array(''),
                                    'color' => array('ideo_theme_options[footer][standard_footer_background][footer_background_color]', 'ideo_theme_options[footer][standard_footer_background][footer_background_color_overlay]'),
                                    'image' => array('ideo_theme_options[footer][standard_footer_background][footer_background_upload_image]', 'ideo_theme_options[footer][standard_footer_background][footer_background_cover]', 'ideo_theme_options[footer][standard_footer_background][footer_background_image_position]', 'ideo_theme_options[footer][standard_footer_background][footer_background_image_repeat]', 'ideo_theme_options[footer][standard_footer_background][footer_background_image_overlay]'),
                                ),
                                'description' => __('Choose Color or Image background type for footer area. Depending on which option you choose appropriate options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_color_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_color'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[footer][standard_footer_background][footer_background_color_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[footer][standard_footer_background][footer_background_color_pattern]', 'ideo_theme_options[footer][standard_footer_background][footer_background_color_pattern_color]'),
                                ),
                                'description' => __('Choose between Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose the additional options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_color_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_color_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_color_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_color_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_color_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_color_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_upload_image]',
                                'type' => 'upload',
                                'label' => esc_html__('UPLOAD IMAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_upload_image'),
                                'description' => __('Upload image which will be set as a background. Only .jpg .png .bmp formats are allowed.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_cover]',
                                'type' => 'switcher',
                                'label' => esc_html__('100% BACKGROUND', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_cover'),
                                'description' => __('Turn On this option to set COVER property for background image size (it will be scale to be as large as possible so that the background area is completely covered by the background image). By default this option is turned Off, so background image size has set <i>auto</i> property (original width and height).', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_image_position]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE POSITION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_image_position'),
                                'choices' => array(
                                    'left_top' => 'Left top',
                                    'center_top' => 'Center top',
                                    'right_top' => 'Right top',
                                    'left_center' => 'Left center',
                                    'center_center' => 'Center center',
                                    'right_center' => 'Right center',
                                    'left_bottom' => 'Left bottom',
                                    'center_bottom' => 'Center bottom',
                                    'right_bottom' => 'Right bottom',
                                ),
                                'description' => __('Choose image position property to set the starting position of background image.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_image_repeat]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE REPEAT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_image_repeat'),
                                'choices' => array(
                                    'no_repeat' => 'No repeat',
                                    'repeat_x' => 'Repeat X',
                                    'repeat_y' => 'Repeat Y',
                                    'repeat' => 'Repeat XY',
                                ),
                                'description' => __('Choose image repeat property to set if/how the background image will be repeated.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_image_overlay]',
                                'type' => 'select',
                                'label' => esc_html__('IMAGE OVERLAY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_image_overlay'),
                                'choices' => array(
                                    'none' => 'None',
                                    'color' => 'COLOR',
                                    'pattern' => 'PATTERN',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'color' => array('ideo_theme_options[footer][standard_footer_background][footer_background_image_overlay_color]'),
                                    'pattern' => array('ideo_theme_options[footer][standard_footer_background][footer_background_image_overlay_pattern]', 'ideo_theme_options[footer][standard_footer_background][footer_background_image_overlay_pattern_color]'),
                                ),
                                'description' => __('Choose Color or Pattern background overlay type or choose None if you do not need any background overlay. Depending on which option you choose several styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_image_overlay_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('OVERLAY COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_image_overlay_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_image_overlay_pattern]',
                                'type' => 'select',
                                'label' => esc_html__('PATTERN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_image_overlay_pattern'),
                                'choices' => array_flip(ideothemo_get_background_patterns(true)),
                                'description' => __('Choose one of predefined pattern types.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_background][footer_background_image_overlay_pattern_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('PATTERN COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_background.footer_background_image_overlay_pattern_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'standard_footer_coloring',
                        'title' => esc_html__('STANDARD FOOTER COLORING', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'separator_footer_light',
                                'type' => 'separator',
                                'label' => esc_html__('LIGHT SKIN', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_coloring][footer_light_accent_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('ACCENT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_coloring.footer_light_accent_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_coloring][footer_light_widgets_title_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('WIDGETS TITLE COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_coloring.footer_light_widgets_title_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_coloring][footer_light_widgets_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('WIDGETS TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_coloring.footer_light_widgets_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'separator_footer_dark',
                                'type' => 'separator',
                                'label' => esc_html__('DARK SKIN', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_coloring][footer_dark_accent_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('ACCENT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_coloring.footer_dark_accent_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_coloring][footer_dark_widgets_title_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('WIDGETS TITLE COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_coloring.footer_dark_widgets_title_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][standard_footer_coloring][footer_dark_widgets_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('WIDGETS TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.standard_footer_coloring.footer_dark_widgets_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'widgets_title_font',
                        'title' => esc_html__('WIDGETS TITLE FONT', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[footer][widgets_title_font][widget_title_font_size]',
                                'type' => 'text',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.widgets_title_font.widget_title_font_size'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][widgets_title_font][widget_title_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.widgets_title_font.widget_title_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][widgets_title_font][widget_title_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.widgets_title_font.widget_title_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][widgets_title_font][widget_title_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.widgets_title_font.widget_title_font_weight'),
                                'depends' => 'ideo_theme_options[footer][widgets_title_font][widget_title_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][widgets_title_font][widget_title_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.widgets_title_font.widget_title_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'copyrights_coloring',
                        'title' => esc_html__('COPYRIGHTS COLORING', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'separator_copyrights_light',
                                'type' => 'separator',
                                'label' => esc_html__('LIGHT SKIN', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_coloring][copyrights_light_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_coloring.copyrights_light_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_coloring][copyrights_light_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_coloring.copyrights_light_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'separator_copyrights_dark',
                                'type' => 'separator',
                                'label' => esc_html__('DARK SKIN', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_coloring][copyrights_dark_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_coloring.copyrights_dark_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_coloring][copyrights_dark_text_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('TEXT COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_coloring.copyrights_dark_text_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'copyrights_font',
                        'title' => esc_html__('COPYRIGHTS FONT', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_font][copyrights_font_size]',
                                'type' => 'text',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_font.copyrights_font_size'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_font][copyrights_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_font.copyrights_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_font][copyrights_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_font.copyrights_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_font][copyrights_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_font.copyrights_font_weight'),
                                'depends' => 'ideo_theme_options[footer][copyrights_font][copyrights_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[footer][copyrights_font][copyrights_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('footer.copyrights_font.copyrights_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                ),
            );