<?php 
$settings[] =  array(
                'id' => 'fonts',
                'title' => esc_html__('FONTS', 'themo'),
                'sections' => array(
                    array(
                        'id' => 'font_family',
                        'title' => esc_html__('GLOBAL FONT EXTENSION', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[fonts][font_family][global_font_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_family.global_font_info'),
                                'description' => __('Choose the global font extension (writing system, alphabet). <b>Nitoce, that some font families do not support all alphabets, so depending on which font extension you choose such font families will be available below, in the Global font family section.</b>', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_family][global_font_extension]',
                                'type' => 'select',
                                'label' => esc_html__('GLOBAL FONT EXTENSION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_family.global_font_extension'),
                                'choices' => ideothemo_get_google_fonts_subsets(),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'body_font_settings',
                        'title' => esc_html__('BODY FONT SETTINGS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[fonts][body_font_settings][body_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('BODY FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.body_font_settings.body_font_family'),
                                'description' => __('Choose global font family. It will affect on every single text element on the site but naturally, you can override font family setting for several text elements in further sections', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][body_font_settings][body_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('BODY FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.body_font_settings.body_font_weight'),
                                'depends' => 'ideo_theme_options[fonts][body_font_settings][body_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][body_font_settings][body_font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('BODY FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.body_font_settings.body_font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][body_font_settings][body_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('BODY LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.body_font_settings.body_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][body_font_settings][body_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('BODY LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.body_font_settings.body_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'text_tag_settings',
                        'title' => esc_html__('TEXT TAG SETTINGS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][text_tag_settings]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TAG SETTINGS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.text_tag_settings'),
                                'choices' => array(
                                    '' => '- select tag -',
                                    'p' => 'p - Paragraph',
                                    'a' => 'a - Link',
                                    'h1' => 'H1 - heading1',
                                    'h2' => 'H2 - heading2',
                                    'h3' => 'H3 - heading3',
                                    'h4' => 'H4 - heading4',
                                    'h5' => 'H5 - heading5',
                                    'h6' => 'H6 - heading6',
                                ),
                                'depending' => array(
                                    'p' => array('ideo_theme_options[fonts][text_tag_settings][p_font_size]', 'ideo_theme_options[fonts][text_tag_settings][p_line_height]', 'ideo_theme_options[fonts][text_tag_settings][p_font_family]', 'ideo_theme_options[fonts][text_tag_settings][p_font_extension]', 'ideo_theme_options[fonts][text_tag_settings][p_font_weight]', 'ideo_theme_options[fonts][text_tag_settings][p_letter_spacing]', 'ideo_theme_options[fonts][text_tag_settings][p_text_transform]', 'ideo_theme_options[fonts][text_tag_settings][p_italic]'),
                                    'a' => array('ideo_theme_options[fonts][text_tag_settings][link_font_size]', 'ideo_theme_options[fonts][text_tag_settings][link_font_style]', 'ideo_theme_options[fonts][text_tag_settings][link_font_weight]', 'ideo_theme_options[fonts][text_tag_settings][link_text_decoration]'),
                                    'h1' => array('ideo_theme_options[fonts][text_tag_settings][h1_font_size]', 'ideo_theme_options[fonts][text_tag_settings][h1_line_height]', 'ideo_theme_options[fonts][text_tag_settings][h1_font_family]', 'ideo_theme_options[fonts][text_tag_settings][h1_font_extension]', 'ideo_theme_options[fonts][text_tag_settings][h1_font_weight]', 'ideo_theme_options[fonts][text_tag_settings][h1_letter_spacing]', 'ideo_theme_options[fonts][text_tag_settings][h1_text_transform]', 'ideo_theme_options[fonts][text_tag_settings][h1_italic]'),
                                    'h2' => array('ideo_theme_options[fonts][text_tag_settings][h2_font_size]', 'ideo_theme_options[fonts][text_tag_settings][h2_line_height]', 'ideo_theme_options[fonts][text_tag_settings][h2_font_family]', 'ideo_theme_options[fonts][text_tag_settings][h2_font_extension]', 'ideo_theme_options[fonts][text_tag_settings][h2_font_weight]', 'ideo_theme_options[fonts][text_tag_settings][h2_letter_spacing]', 'ideo_theme_options[fonts][text_tag_settings][h2_text_transform]', 'ideo_theme_options[fonts][text_tag_settings][h2_italic]'),
                                    'h3' => array('ideo_theme_options[fonts][text_tag_settings][h3_font_size]', 'ideo_theme_options[fonts][text_tag_settings][h3_line_height]', 'ideo_theme_options[fonts][text_tag_settings][h3_font_family]', 'ideo_theme_options[fonts][text_tag_settings][h3_font_extension]', 'ideo_theme_options[fonts][text_tag_settings][h3_font_weight]', 'ideo_theme_options[fonts][text_tag_settings][h3_letter_spacing]', 'ideo_theme_options[fonts][text_tag_settings][h3_text_transform]', 'ideo_theme_options[fonts][text_tag_settings][h3_italic]'),
                                    'h4' => array('ideo_theme_options[fonts][text_tag_settings][h4_font_size]', 'ideo_theme_options[fonts][text_tag_settings][h4_line_height]', 'ideo_theme_options[fonts][text_tag_settings][h4_font_family]', 'ideo_theme_options[fonts][text_tag_settings][h4_font_extension]', 'ideo_theme_options[fonts][text_tag_settings][h4_font_weight]', 'ideo_theme_options[fonts][text_tag_settings][h4_letter_spacing]', 'ideo_theme_options[fonts][text_tag_settings][h4_text_transform]', 'ideo_theme_options[fonts][text_tag_settings][h4_italic]'),
                                    'h5' => array('ideo_theme_options[fonts][text_tag_settings][h5_font_size]', 'ideo_theme_options[fonts][text_tag_settings][h5_line_height]', 'ideo_theme_options[fonts][text_tag_settings][h5_font_family]', 'ideo_theme_options[fonts][text_tag_settings][h5_font_extension]', 'ideo_theme_options[fonts][text_tag_settings][h5_font_weight]', 'ideo_theme_options[fonts][text_tag_settings][h5_letter_spacing]', 'ideo_theme_options[fonts][text_tag_settings][h5_text_transform]', 'ideo_theme_options[fonts][text_tag_settings][h5_italic]'),
                                    'h6' => array('ideo_theme_options[fonts][text_tag_settings][h6_font_size]', 'ideo_theme_options[fonts][text_tag_settings][h6_line_height]', 'ideo_theme_options[fonts][text_tag_settings][h6_font_family]', 'ideo_theme_options[fonts][text_tag_settings][h6_font_extension]', 'ideo_theme_options[fonts][text_tag_settings][h6_font_weight]', 'ideo_theme_options[fonts][text_tag_settings][h6_letter_spacing]', 'ideo_theme_options[fonts][text_tag_settings][h6_text_transform]', 'ideo_theme_options[fonts][text_tag_settings][h6_italic]'),
                                ),
                                'description' => __('You can customize html text tags: p, a, and h1-h6. You can customize all tags separately. Simply choose from dropdown single tag and appropriate font options for chosen tag will be available below. Customize font options for chosen tag and when you finish simply choose another tag from dropdown and customize it as well. Do the same for each tag one by one.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][p_font_size]',
                                'type' => 'text',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.p_font_size'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][p_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.p_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][p_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.p_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][p_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.p_font_weight'),
                                'depends' => 'ideo_theme_options[fonts][text_tag_settings][p_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][p_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.p_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][p_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.p_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][link_font_style]',
                                'type' => 'select',
                                'label' => esc_html__('FONT STYLE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.link_font_style'),
                                'choices' => array(
                                    'normal' => 'Normal',
                                    'italic' => 'Italic',
                                    'inherit' => 'Inherit',
                                    'initial' => 'Initial',
                                    'oblique' => 'Oblique',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][link_font_weight]',
                                'type' => 'select',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.link_font_weight'),
                                'choices' => ideothemo_get_google_fonts_variants(),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][link_text_decoration]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT DECORATION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.link_text_decoration'),
                                'choices' => array(
                                    'none' => 'None',
                                    'underline' => 'Underline',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h1_font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h1_font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h1_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h1_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h1_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h1_font_family'),
                                'choices' => ideothemo_get_google_fonts_as_options(true),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h1_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h1_font_weight'),
                                'depends' => 'ideo_theme_options[fonts][text_tag_settings][h1_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h1_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h1_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h1_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h1_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h2_font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h2_font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h2_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h2_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h2_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h2_font_family'),
                                'choices' => ideothemo_get_google_fonts_as_options(true),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h2_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h2_font_weight'),
                                'depends' => 'ideo_theme_options[fonts][text_tag_settings][h2_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h2_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h2_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h2_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h2_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h3_font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h3_font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h3_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h3_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h3_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h3_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h3_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h3_font_weight'),
                                'depends' => 'ideo_theme_options[fonts][text_tag_settings][h3_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h3_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h3_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h3_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h3_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h4_font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h4_font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h4_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h4_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h4_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h4_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h4_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h4_font_weight'),
                                'depends' => 'ideo_theme_options[fonts][text_tag_settings][h4_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h4_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h4_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h4_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h4_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h5_font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h5_font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h5_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h5_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h5_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h5_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h5_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h5_font_weight'),
                                'depends' => 'ideo_theme_options[fonts][text_tag_settings][h5_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h5_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h5_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h5_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h5_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h6_font_size]',
                                'type' => 'slider',
                                'label' => esc_html__('FONT SIZE (px)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h6_font_size'),
                                'choices' => array(
                                    'min' => '8',
                                    'max' => '72',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h6_line_height]',
                                'type' => 'text',
                                'label' => esc_html__('LINE HEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h6_line_height'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h6_font_family]',
                                'type' => 'select-fonts',
                                'label' => esc_html__('FONT FAMILY', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h6_font_family'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h6_font_weight]',
                                'type' => 'select-fonts-weight',
                                'label' => esc_html__('FONT WEIGHT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h6_font_weight'),
                                'depends' => 'ideo_theme_options[fonts][text_tag_settings][h6_font_family]',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h6_letter_spacing]',
                                'type' => 'text',
                                'label' => esc_html__('LETTER SPACING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h6_letter_spacing'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][text_tag_settings][h6_text_transform]',
                                'type' => 'select',
                                'label' => esc_html__('TEXT TRANSFORM', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.text_tag_settings.h6_text_transform'),
                                'choices' => array(
                                    'none' => 'None',
                                    'capitalize' => 'Capitalize',
                                    'uppercase' => 'Uppercase',
                                    'lowercase' => 'Lowercase',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'font_coloring',
                        'title' => esc_html__('COLORING', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][font_coloring_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('In this section you can customize text tags colors: set main coloring skin and customize colors for each text tag separately, for chosen skin.</br> <b>!!! Notice, that these settings refer only for text tags which you add using WordPress text editor. So skip this section if your are going to build your content using Visual Composer shortcodes. Shortcodes base on Smart Coloring so use options in Shortcodes/Styling section to color texts in shortcodes.</b>', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][body_text_skin]',
                                'type' => 'select',
                                'label' => esc_html__('BODY TEXT SKIN', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.body_text_skin'),
                                'choices' => array(
                                    'default' => 'Default',
                                    'light' => 'Light',
                                    'dark' => 'Dark',
                                ),
                                'description' => __('Choose between Light and Dark skin for text tags or choose Default to use colors from Theme skin which you have chosen in Generals section.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][seledyn_light]',
                                'type' => 'separator',
                                'label' => esc_html__('LIGHT SKIN', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][h1]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H1 - heading1', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.h1'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][h2]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H2 - heading2', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.h2'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][h3]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H3 - heading3', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.h3'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][h4]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H4 - heading4', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.h4'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][h5]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H5 - heading5', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.h5'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][h6]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H6 - heading6', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.h6'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][paragraph]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('p - paragraph', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.paragraph'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][link]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('a - link', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.link'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][light][link_hover]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('a - link hover', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.light.link_hover'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][seledyn_dark]',
                                'type' => 'separator',
                                'label' => esc_html__('DARK SKIN', 'themo'),
                                'default' => '',
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][h1]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H1 - heading1', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.h1'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][h2]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H2 - heading2', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.h2'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][h3]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H3 - heading3', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.h3'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][h4]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H4 - heading4', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.h4'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][h5]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H5 - heading5', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.h5'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][h6]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('H6 - heading6', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.h6'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][paragraph]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('p - paragraph', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.paragraph'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][link]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('a - link', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.link'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[fonts][font_coloring][dark][link_hover]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('a - link hover', 'themo'),
                                'default' => ideothemo_get_themo_default_value('fonts.font_coloring.dark.link_hover'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                ),
            );