<?php
$settings[] = array(
                'id' => 'blog',
                'title' => esc_html__('BLOG', 'themo'),
                'sections' => array(
                    array(
                        'id' => 'blog_settings',
                        'title' => esc_html__('SETTINGS', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[blog][blog_settings][blog_settings_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('In this tab you can enable or disable blog elements such as Author, Comments, Date, Tags and Categories. These settings will work for whole blog, globally: for single posts, for blog lists, archive and categories pages, and for search results pages.</br> These options do not work for blog added using The Grid plugin.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_settings][blog_hide_authors]',
                                'type' => 'switcher',
                                'label' => esc_html__('AUTHORS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_settings.blog_hide_authors'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_settings][blog_hide_comments]',
                                'type' => 'switcher',
                                'label' => esc_html__('COMMENTS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_settings.blog_hide_comments'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_settings][blog_hide_date]',
                                'type' => 'switcher',
                                'label' => esc_html__('DATE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_settings.blog_hide_date'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_settings][blog_hide_tags]',
                                'type' => 'switcher',
                                'label' => esc_html__('TAGS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_settings.blog_hide_tags'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_settings][blog_hide_categories]',
                                'type' => 'switcher',
                                'label' => esc_html__('CATEGORIES', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_settings.blog_hide_categories'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'blog_single',
                        'title' => esc_html__('SINGLE POST', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_sidebar]',
                                'type' => 'select',
                                'label' => esc_html__('SIDEBAR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_sidebar'),
                                'choices' => array(
                                    '' => 'Default',
                                    'none' => 'No sidebar',
                                    'left_sidebar' => 'Left sidebar',
                                    'right_sidebar' => 'Right sidebar',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'left_sidebar' => array('ideo_theme_options[blog][blog_single][blog_sidebar_choose]'),
                                    'right_sidebar' => array('ideo_theme_options[blog][blog_single][blog_sidebar_choose]'),
                                ),
                                'description' => __('Choose between Left or Right sidebar position or choose No sidebar if you do not want to display sidebar on single post pages.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_sidebar_choose]',
                                'type' => 'select',
                                'label' => esc_html__('CHOOSE SIDEBAR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_sidebar_choose'),
                                'choices' => ideothemo_get_sidebars(),
                                'description' => __('Choose from dropdown one of sidebars you have created in WordPress widgets panel.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_navigation]',
                                'type' => 'switcher',
                                'label' => esc_html__('NAVIGATION ARROWS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_navigation'),
                                'description' => __('Turn On or Off next and previous arrows on single post pages which allows you to navigate between all posts.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_featured_image]',
                                'type' => 'switcher',
                                'label' => esc_html__('POST FEATURED MEDIA', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_featured_image'),
                                'description' => __('Turn On or Off featured media displaying on single post page - featured media are displayed at the top of single post pages.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_post_title]',
                                'type' => 'switcher',
                                'label' => esc_html__('POST TITLE ', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_post_title'),
                                'description' => __('Turn On or Off post title displaying on single post page.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_meta]',
                                'type' => 'switcher',
                                'label' => esc_html__('META', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_meta'),
                                'description' => __('Turn On or Off meta data box displaying on single post page.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_related_posts]',
                                'type' => 'switcher',
                                'label' => esc_html__('RELATED POSTS BOX', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_related_posts'),
                                'description' => __('Turn On or Off related post box displaying on single post page.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_socials]',
                                'type' => 'switcher',
                                'label' => esc_html__('SOCIAL MEDIA SHARE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_socials'),
                                'depending' => array(
                                    'true' => array('ideo_theme_options[blog][blog_single][blog_single_facebook]', 'ideo_theme_options[blog][blog_single][blog_single_twitter]', 'ideo_theme_options[blog][blog_single][blog_single_google]', 'ideo_theme_options[blog][blog_single][blog_single_pinterest]', 'ideo_theme_options[blog][blog_single][blog_single_reddit]', 'ideo_theme_options[blog][blog_single][blog_single_linkedin]', 'ideo_theme_options[blog][blog_single][blog_single_tumblr]', 'ideo_theme_options[blog][blog_single][blog_single_vk]', 'ideo_theme_options[blog][blog_single][blog_single_email]'),
                                    'false' => array(''),
                                ),
                                'description' => __('Turn On or Off social media share box. If it is On social media checkboxes will be available below, check those which you want to display in social media share box.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_facebook]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Facebook', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_facebook'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_twitter]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Twitter', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_twitter'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_google]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Google+', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_google'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_pinterest]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Pinterest', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_pinterest'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_reddit]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Reddit', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_reddit'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_linkedin]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Linkedin', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_linkedin'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_tumblr]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Tumblr', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_tumblr'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_vk]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Vk', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_vk'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_single][blog_single_email]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Email', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_single.blog_single_email'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'blog_archives',
                        'title' => esc_html__('ARCHIVE/CATEGORIES PAGES', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_layout]',
                                'type' => 'select',
                                'label' => esc_html__('BLOG ARCHIVE/CATEGORY LAYOUT ', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_layout'),
                                'choices' => array(
                                    'classic' => 'Classic',
                                    'masonry' => 'Masonry',
                                ),
                                'depending' => array(
                                    'masonry' => array('ideo_theme_options[blog][blog_archives][blog_archives_masonry_blocks]', 'ideo_theme_options[blog][blog_archives][blog_archives_block_distance]'),
                                ),
                                'description' => __('Choose between Classic and Masonry layout for archive pages.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_masonry_blocks]',
                                'type' => 'text',
                                'label' => esc_html__('MASONRY COLUMNS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_masonry_blocks'),
                                'description' => __('Set number of columns for masonry layout.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_block_distance]',
                                'type' => 'slider',
                                'label' => esc_html__('DISTANCE BETWEEN BLOCKS (PX)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_block_distance'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '100',
                                    'step' => '1',
                                ),
                                'description' => __('Define in pixels distance between masonry grid columns.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_sidebar]',
                                'type' => 'select',
                                'label' => esc_html__('SIDEBAR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_sidebar'),
                                'choices' => array(
                                    '' => 'Default',
                                    'none' => 'No sidebar',
                                    'left_sidebar' => 'Left sidebar',
                                    'right_sidebar' => 'Right sidebar',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'left_sidebar' => array('ideo_theme_options[blog][blog_archives][blog_archives_sidebar_choose]'),
                                    'right_sidebar' => array('ideo_theme_options[blog][blog_archives][blog_archives_sidebar_choose]'),
                                ),
                                'description' => __('Choose between Left and Right sidebar position on archive pages or choose No sidebar if you do not want to display sidebar.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_sidebar_choose]',
                                'type' => 'select',
                                'label' => esc_html__('CHOOSE SIDEBAR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_sidebar_choose'),
                                'choices' => ideothemo_get_sidebars(),
                                'description' => __('Choose from dropdown one of sidebars you have created in WordPress widget panel.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_pt]',
                                'type' => 'select',
                                'label' => esc_html__('ARCHIVE PAGE STYLING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_pt'),
                                'choices' => ideothemo_get_pages_as_option(),
                                'description' => __('Choose page from which you want to copy page options to the Archieves pages. All styling options for all page elements like layout and backgrounds, header, page title etc., will be copied from chosen page. You can choose one of already created page or create a single page customized strictly for Archieves.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_posts_per_page]',
                                'type' => 'text',
                                'label' => esc_html__('POST PER PAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_posts_per_page'),
                                'description' => __('Enter number of post you want to displayed on single archive page.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_pagination]',
                                'type' => 'select',
                                'label' => esc_html__('PAGINATION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_pagination'),
                                'choices' => array(
                                    'standard' => 'Standard pagination',
                                    'load_more' => 'Load more button',
                                    'infinity_scroll' => 'Infinity scroll',
                                ),
                                'description' => __('Choose posts pagination type for archive pages. You can choose between Standard Pagination, Load more button and Infinite scroll. 
</br><b>Standard pagination</b> displays  numbered buttons at the bottom of the page, so you can navigate through particular pages; 
</br><b>Load more button</b> (displayed at the bottom of the page) allows you to load more posts on click; 
</br><b>Infinite scroll</b> automatically loads more posts while scrolling the page down.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_excerpt_words]',
                                'type' => 'text',
                                'label' => esc_html__('EXCERPT WORDS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_excerpt_words'),
                                'description' => __('Enter number of words you want to display as excerpt in each post on post list.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_socials]',
                                'type' => 'switcher',
                                'label' => esc_html__('SOCIAL MEDIA SHARE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_socials'),
                                'depending' => array(
                                    'true' => array('ideo_theme_options[blog][blog_archives][blog_archives_facebook]', 'ideo_theme_options[blog][blog_archives][blog_archives_twitter]', 'ideo_theme_options[blog][blog_archives][blog_archives_google]', 'ideo_theme_options[blog][blog_archives][blog_archives_pinterest]', 'ideo_theme_options[blog][blog_archives][blog_archives_reddit]', 'ideo_theme_options[blog][blog_archives][blog_archives_linkedin]', 'ideo_theme_options[blog][blog_archives][blog_archives_tumblr]', 'ideo_theme_options[blog][blog_archives][blog_archives_vk]', 'ideo_theme_options[blog][blog_archives][blog_archives_email]'),
                                    'false' => array(''),
                                ),
                                'description' => __('Turn On or Off social media share box. If it is turned On social media checkboxes will be available below, check those which you want to display in social media share box.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_facebook]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Facebook', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_facebook'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_twitter]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Twitter', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_twitter'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_google]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Google+', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_google'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_pinterest]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Pinterest', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_pinterest'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_reddit]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Reddit', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_reddit'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_linkedin]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Linkedin', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_linkedin'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_tumblr]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Tumblr', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_tumblr'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_vk]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Vk', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_vk'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_email]',
                                'type' => 'checkbox',
                                'label' => esc_html__('Email', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_email'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_meta]',
                                'type' => 'switcher',
                                'label' => esc_html__('CUSTOM META', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_meta'),
                                'depending' => array(
                                    'false' => array(''),
                                    'true' => array('ideo_theme_options[blog][blog_archives][blog_archives_categories]', 'ideo_theme_options[blog][blog_archives][blog_archives_tags]', 'ideo_theme_options[blog][blog_archives][blog_archives_date]', 'ideo_theme_options[blog][blog_archives][blog_archives_comments]', 'ideo_theme_options[blog][blog_archives][blog_archives_authors]'),
                                ),
                                'description' => __('Turn On or Off social media share box. If it is turned On social media checkboxes will be available below, check those which you want to display in social media share box.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_authors]',
                                'type' => 'switcher',
                                'label' => esc_html__('AUTHORS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_authors'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_comments]',
                                'type' => 'switcher',
                                'label' => esc_html__('COMMENTS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_comments'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_date]',
                                'type' => 'switcher',
                                'label' => esc_html__('DATE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_date'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_tags]',
                                'type' => 'switcher',
                                'label' => esc_html__('TAGS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_tags'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_archives][blog_archives_categories]',
                                'type' => 'switcher',
                                'label' => esc_html__('CATEGORIES', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_archives.blog_archives_categories'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'blog_search',
                        'title' => esc_html__('SEARCH PAGE', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_info]',
                                'type' => 'info',
                                'label' => esc_html__('INFO:', 'themo'),
                                'default' => '',
                                'description' => __('To turn on the Search results page on the preview screen add to the link in browser this phrase: ?url=<b>yourdomain</b>?s=<b>searchphrase</b>', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_sidebar]',
                                'type' => 'select',
                                'label' => esc_html__('SIDEBAR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_sidebar'),
                                'choices' => array(
                                    '' => 'Default',
                                    'none' => 'No sidebar',
                                    'left_sidebar' => 'Left sidebar',
                                    'right_sidebar' => 'Right sidebar',
                                ),
                                'depending' => array(
                                    'none' => array(''),
                                    'left_sidebar' => array('ideo_theme_options[blog][blog_search][blog_search_sidebar_choose]'),
                                    'right_sidebar' => array('ideo_theme_options[blog][blog_search][blog_search_sidebar_choose]'),
                                ),
                                'description' => __('Choose between Left and Right sidebar position on search result page or choose No sidebar if you do not want to display sidebar.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_sidebar_choose]',
                                'type' => 'select',
                                'label' => esc_html__('CHOOSE SIDEBAR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_sidebar_choose'),
                                'choices' => ideothemo_get_sidebars(),
                                'description' => __('Choose from dropdown one of sidebars you have created in WordPress widget panel.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_posts_per_page]',
                                'type' => 'text',
                                'label' => esc_html__('POST PER PAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_posts_per_page'),
                                'description' => __('Enter number of post you want to displayed on search result page.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_excerpt_words]',
                                'type' => 'text',
                                'label' => esc_html__('EXCERPT WORDS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_excerpt_words'),
                                'description' => __('Enter number of words you want to display as excerpt in each post on post list.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_pagination]',
                                'type' => 'select',
                                'label' => esc_html__('PAGINATION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_pagination'),
                                'choices' => array(
                                    'standard' => 'Standard pagination',
                                    'load_more' => 'Load more button',
                                    'infinity_scroll' => 'Infinity scroll',
                                ),
                                'description' => __('Choose posts pagination type for search results page. You can choose between Standard Pagination, Load more button and Infinite scroll. 
</br><b>Standard pagination</b> displays  numbered buttons at the bottom of the page, so you can navigate through particular pages; 
</br><b>Load more button</b> (displayed at the bottom of the page) allows you to load more posts on click; 
</br><b>Infinite scroll</b> automatically loads more posts while scrolling the page down.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_pt]',
                                'type' => 'select',
                                'label' => esc_html__('SEARCH PAGE STYLING', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_pt'),
                                'choices' => ideothemo_get_pages_as_option(),
                                'description' => __('Choose page from which you want to copy page options to the Search pages. All styling options for all page elements like layout and backgrounds, header, page title etc., will be copied from chosen page. You can choose one of already created page or create a single page customized strictly for Search pages.', 'themo'),
                                'transport' => 'refresh',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_featured_image]',
                                'type' => 'switcher',
                                'label' => esc_html__('FEATURED MEDIA ON SEARCH RESULT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_featured_image'),
                                'description' => __('Turn On or Off posts featured media displaying on search results page.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_meta_date]',
                                'type' => 'switcher',
                                'label' => esc_html__('META DATE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_meta_date'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[blog][blog_search][blog_search_meta_author]',
                                'type' => 'switcher',
                                'label' => esc_html__('META AUTHOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('blog.blog_search.blog_search_meta_author'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                ),
            );