<?php 
$settings[] = array(
                'id' => 'advanced',
                'title' => esc_html__('ADVANCED', 'themo'),
                'sections' => array(
                    array(
                        'id' => 'advanced_loading',
                        'title' => esc_html__('PAGE LOADING ', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_loading][advanced_sticky_loading]',
                                'type' => 'switcher',
                                'label' => esc_html__('PAGE TRANSITION', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_loading.advanced_sticky_loading'),
                                'depending' => array(
                                    'true' => array(
                                        'ideo_theme_options[advanced][advanced_loading][advanced_loader]',
                                        'ideo_theme_options[advanced][advanced_loading][advanced_loader_background_color]',
                                        'ideo_theme_options[advanced][advanced_loading][advanced_loader_color]',
                                        'ideo_theme_options[advanced][advanced_loading][advanced_loader_color]',
                                    ),
                                    'true' => array('ideo_theme_options[advanced][advanced_loading][transition_in]',
                                        'ideo_theme_options[advanced][advanced_loading][transition_out]',
                                        'ideo_theme_options[advanced][advanced_loading][logo]',
                                        'ideo_theme_options[advanced][advanced_loading][advanced_loader]',
                                        'ideo_theme_options[advanced][advanced_loading][advanced_loader_background_color]',
                                        'ideo_theme_options[advanced][advanced_loading][advanced_loader_color]',
                                        'ideo_theme_options[advanced][advanced_loading][logo_retina]'),
                                    'false' => array(''),
                                ),
                                'description' => __('Turn On or Off animated page transition effect. If its On two additional options will be available below, so you can choose transition animations for page entry and for page exit.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_loading][transition_in]',
                                'type' => 'select',
                                'label' => esc_html__('PAGE TRANSITION IN ', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_loading.transition_in'),
                                'choices' => array(
                                    'fade-in' => 'Fade',
                                    'fade-in-down-sm' => 'Fade down',
                                    'fade-in-up-sm' => 'Fade up',
                                    'fade-in-left-sm' => 'Fade left',
                                    'fade-in-right-sm' => 'Fade right',
                                    'zoom-in' => 'Zoom',
                                ),
                                'description' => __('Choose one of predefined page loaders.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_loading][transition_out]',
                                'type' => 'select',
                                'label' => esc_html__('PAGE TRANSITION OUT', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_loading.transition_out'),
                                'choices' => array(
                                    'fade-out' => 'Fade',
                                    'fade-out-down-sm' => 'Fade down',
                                    'fade-out-up-sm' => 'Fade up',
                                    'fade-out-left-sm' => 'Fade left',
                                    'fade-out-right-sm' => 'Fade right',
                                    'zoom-out' => 'Zoom',
                                ),
                                'description' => __('Choose one of predefined page loaders.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_loading][logo]',
                                'type' => 'upload',
                                'label' => esc_html__('PAGE LOADING LOGO', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_loading.logo'),
                                'description' => __('Upload image/logo which will be displayed on first page load.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_loading][logo_retina]',
                                'type' => 'upload',
                                'label' => esc_html__('PAGE LOADING LOGO RETINA', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_loading.logo_retina'),
                                'description' => __('Upload retina image/logo which will be displayed on first page load.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_loading][advanced_loader]',
                                'type' => 'select',
                                'label' => esc_html__('LOADER', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_loading.advanced_loader'),
                                'choices' => array(
                                    'chasing-dots' => 'Chasing dots',
                                    'circle' => 'Circle',
                                    'cube-grid' => 'Cube grid',
                                    'double-bounce' => 'Double bounce',
                                    'fading-circle' => 'Fading circle',
                                    'folding-cube' => 'Folding cube',
                                    'rotating-plane' => 'Rotating plane',
                                    'spinner-pulse' => 'Spinner pulsce',
                                    'three-bounce' => 'Three bounce',
                                    'wandering-cubes' => 'Wandering cubes',
                                    'wave' => 'Wave',
                                    'ball-pulse' => 'Ball pulse',
                                    'ball-grid-pulse' => 'Ball grid pulse',
                                    'ball-clip-rotate' => 'Ball clip rotate',
                                    'ball-clip-rotate-pulse' => 'Ball clip rotate pulse',
                                    'square-spin' => 'Square spin',
                                    'ball-clip-rotate-multiple' => 'Ball clip rotate multiple',
                                    'ball-pulse-rise' => 'Ball pulse rise',
                                    'ball-rotate' => 'Ball rotate',
                                    'cube-transition' => 'Cube transition',
                                    'ball-zig-zag' => 'Ball zig zag',
                                    'ball-zig-zag-deflect' => 'Ball zig zag deflect',
                                    'ball-triangle-path' => 'Ball triangle path',
                                    'ball-scale' => 'Ball scale',
                                    'line-scale' => 'Line scale',
                                    'line-scale-party' => 'Line scale party',
                                    'ball-scale-multiple' => 'Ball scale multiple',
                                    'ball-pulse-sync' => 'Ball pulse sync',
                                    'ball-beat' => 'Ball beat',
                                    'line-scale-pulse-out' => 'Line scale pulse out',
                                    'line-scale-pulse-out-rapid' => 'Line scale pulse out rapid',
                                    'ball-scale-ripple' => 'Ball scale ripple',
                                    'ball-scale-ripple-multiple' => 'Ball scale ripple multiple',
                                    'ball-spin-fade-loader' => 'Ball spin fade loader',
                                    'line-spin-fade-loader' => 'Line spin fade loader',
                                    'triangle-skew-spin' => 'Triangle skew spin',
                                    'pacman' => 'Pacman',
                                    'ball-grid-beat' => 'Ball grid beat',
                                    'semi-circle-spin' => 'Semi circle spin'
                                ),
                                'description' => __('Choose one of predefined page loaders.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_loading][advanced_loader_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_loading.advanced_loader_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_loading][advanced_loader_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('LOADER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_loading.advanced_loader_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'advanced_backtotop',
                        'title' => esc_html__('BACK TO TOP BUTTON', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_button]',
                                'type' => 'switcher',
                                'label' => esc_html__('BACK TO TOP BUTTON ', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_backtotop.advanced_backtotop_button'),
                                'depending' => array(
                                    'true' => array(
                                        'ideo_theme_options[advanced][advanced_backtotop][scroll_speed]',
                                        'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_radius]',
                                        'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_background_color]',
                                        'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_background_hover_color]',
                                        'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_icon_color]',
                                        'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_icon_hover_color]',
                                    ),
                                    'false' => array(''),
                                ),
                                'description' => __('Turn On or Off Back to top button. Back to top button is displayed in the right-bottom corner of the screen and it allows you to scroll back to the top of the page. If you turn it On several styling options will be available below.', 'themo'),
                                'transport' => 'postMessage',
                            ),

                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_backtotop][scroll_speed]',
                                'type' => 'text',
                                'label' => esc_html__('SCROLL SPEED (ms)', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_backtotop.scroll_speed'),
                                'description' => __('This option refers to the speed at which the page will be scrolled up when you click Bck to top button. Its value defines how fast every 1000px will be scrolled.', 'themo'),
                                'transport' => 'postMessage',
                            ),

                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_radius]',
                                'type' => 'slider',
                                'label' => esc_html__('BORDER RADIUS', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_backtotop.advanced_backtotop_radius'),
                                'choices' => array(
                                    'min' => '0',
                                    'max' => '50',
                                    'step' => '1',
                                ),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_background_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_backtotop.advanced_backtotop_background_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_background_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('BACKGROUND HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_backtotop.advanced_backtotop_background_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_icon_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('ICON COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_backtotop.advanced_backtotop_icon_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_backtotop][advanced_backtotop_icon_hover_color]',
                                'type' => 'alphacolor',
                                'label' => esc_html__('ICON HOVER COLOR', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_backtotop.advanced_backtotop_icon_hover_color'),
                                'description' => '',
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'advanced_404',
                        'title' => esc_html__('CUSTOM 404', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_404][404_choose]',
                                'type' => 'select',
                                'label' => esc_html__('CHOOSE 404 PAGE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_404.404_choose'),
                                'choices' => array('' => esc_html__('None', 'themo')) + ideothemo_get_list_pages(),
                                'description' => __('Choose the page which you want to display as 404 page.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'advanced_onepage',
                        'title' => esc_html__('ONE PAGE', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_onepage][scroll_speed]',
                                'type' => 'text',
                                'label' => esc_html__('SCROLL SPEED', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_onepage.scroll_speed'),
                                'description' => __('It refers to Onepage navigation and every other element which is linked by anchors. This option defines how fast every 1000px will be scrolled after click.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'advanced_open_graph',
                        'title' => esc_html__('OPEN GRAPH (SOCIAL SHARE)', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_open_graph][open_graph]',
                                'type' => 'switcher',
                                'label' => esc_html__('OPEN GRAPH', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_open_graph.open_graph'),
                                'description' => __('Turn off this option if you are going to use open graph plugins.', 'themo'),
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                    array(
                        'id' => 'advanced_viewport',
                        'title' => esc_html__('VIEWPORT', 'themo'),
                        'controls' => array(
                            array(
                                'id' => 'ideo_theme_options[advanced][advanced_viewport][disable_on_mobile]',
                                'type' => 'switcher',
                                'label' => esc_html__('DISABLE ON MOBILE', 'themo'),
                                'default' => ideothemo_get_themo_default_value('advanced.advanced_viewport.disable_on_mobile'),
                                'description' => null,
                                'transport' => 'postMessage',
                            ),
                        ),
                    ),
                ),
            );